/*****************************************************************************/
/*
  display.c: animate a data file.
*/
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "../graphics-x11/pixels.h"
#include "../graphics-x11/views.h"
#include "../mrdplot/mrdplot.h"
#include "sdfast/b1g.h"
#include "main.h"

/*****************************************************************************/

#define N_CHANNELS 8

#define TIME 0
#define HIP_X 1
#define HIP_Z 2
#define PITCH 3
#define L_HIP 4
#define R_HIP 5
#define L_KNEE 6
#define R_KNEE 7

/*****************************************************************************/

int channels[N_CHANNELS];

/*****************************************************************************/
/*****************************************************************************/

SIM sim;

/*****************************************************************************/
extern float last_x1, last_y1, last_x2, last_y2;
float body_x1, body_y1, body_x2, body_y2;
float left_thigh_x1, left_thigh_y1, left_thigh_x2, left_thigh_y2;
float left_calf_x1, left_calf_y1, left_calf_x2, left_calf_y2;
float right_thigh_x1, right_thigh_y1, right_thigh_x2, right_thigh_y2;
float right_calf_x1, right_calf_y1, right_calf_x2, right_calf_y2;

static int first_time = 1;

View v, *pv;

double xt[N_CHANNELS];

/************************************************************************/
/************************************************************************/

void display_stuff()
{
  double hip_x, hip_z;
  double body_x, body_z;
  double knee_x[2], knee_z[2];
  double foot_x[2], foot_z[2];

  vdraw_line( -0.5, 0.0, 5.5, 0.0, SET, pv );
  vdraw_line( 0.0, -0.05, 0.0, 0.55, SET, pv );
  vdraw_line( 5.0, -0.05, 5.0, 0.55, SET, pv );

  hip_x = xt[Q_X];
  hip_z = xt[Q_Z];
  body_x = hip_x + sim.torso_length*sin(xt[Q_PITCH]);
  body_z = hip_z + sim.torso_length*cos(xt[Q_PITCH]);
  knee_x[LEFT] = hip_x - sim.thigh_length*sin(xt[Q_PITCH] + xt[Q_L_HIP]);
  knee_z[LEFT] = hip_z - sim.thigh_length*cos(xt[Q_PITCH] + xt[Q_L_HIP]);
  knee_x[RIGHT] = hip_x - sim.thigh_length*sin(xt[Q_PITCH] + xt[Q_R_HIP]);
  knee_z[RIGHT] = hip_z - sim.thigh_length*cos(xt[Q_PITCH] + xt[Q_R_HIP]);
  foot_x[LEFT] = knee_x[LEFT] - sim.calf_length*sin(xt[Q_PITCH] + xt[Q_L_HIP] + xt[Q_L_KNEE]);
  foot_z[LEFT] = knee_z[LEFT] - sim.calf_length*cos(xt[Q_PITCH] + xt[Q_L_HIP] + xt[Q_L_KNEE]);
  foot_x[RIGHT] = knee_x[RIGHT] - sim.calf_length*sin(xt[Q_PITCH] + xt[Q_R_HIP] + xt[Q_R_KNEE]);
  foot_z[RIGHT] = knee_z[RIGHT] - sim.calf_length*cos(xt[Q_PITCH] + xt[Q_R_HIP] + xt[Q_R_KNEE]);

  vdraw_line( hip_x, hip_z, body_x, body_z, SET, pv );
  body_x1 = last_x1;
  body_y1 = last_y1;
  body_x2 = last_x2;
  body_y2 = last_y2;

  vdraw_line( hip_x, hip_z, knee_x[LEFT], knee_z[LEFT], SET, pv );
  left_thigh_x1 = last_x1;
  left_thigh_y1 = last_y1;
  left_thigh_x2 = last_x2;
  left_thigh_y2 = last_y2;

  vdraw_line( hip_x, hip_z, knee_x[RIGHT], knee_z[RIGHT], SET, pv );
  right_thigh_x1 = last_x1;
  right_thigh_y1 = last_y1;
  right_thigh_x2 = last_x2;
  right_thigh_y2 = last_y2;

  vdraw_line( knee_x[LEFT], knee_z[LEFT], foot_x[LEFT], foot_z[LEFT], SET, pv );
  left_calf_x1 = last_x1;
  left_calf_y1 = last_y1;
  left_calf_x2 = last_x2;
  left_calf_y2 = last_y2;

  vdraw_line( knee_x[RIGHT], knee_z[RIGHT], foot_x[RIGHT], foot_z[RIGHT], SET, pv );
  right_calf_x1 = last_x1;
  right_calf_y1 = last_y1;
  right_calf_x2 = last_x2;
  right_calf_y2 = last_y2;

  flush_graphics();

  /*
  printf( "hip: %g %g\n", hip_x, hip_z );
  printf( "knee: %g %g %g %g\n", knee_x[LEFT], knee_z[LEFT], knee_x[RIGHT], knee_z[RIGHT] );
  printf( "foot: %g %g %g %g\n", foot_x[LEFT], foot_z[LEFT], foot_x[RIGHT], foot_z[RIGHT] );
  printf( "Press return to continue.\n" );
  getchar();
  */
}

/************************************************************************/

void erase_stuff()
{
  _vdraw_line( right_calf_x1, right_calf_y1, right_calf_x2, right_calf_y2,
	       CLEAR );
  _vdraw_line( left_calf_x1, left_calf_y1, left_calf_x2, left_calf_y2,
	       CLEAR );
  _vdraw_line( right_thigh_x1, right_thigh_y1, right_thigh_x2, right_thigh_y2,
	       CLEAR );
  _vdraw_line( left_thigh_x1, left_thigh_y1, left_thigh_x2, left_thigh_y2,
	       CLEAR );
  _vdraw_line( body_x1, body_y1, body_x2, body_y2, CLEAR );
}

/************************************************************************/

void redisplay_stuff()
{
  static int count = 0;

  /*
  count++;
  if ( count < 30 )
    return;
  count = 0;
  */

  erase_stuff();
  display_stuff();
}

/************************************************************************/

void reinit_display()
{
  clear_window();
  display_stuff();
  first_time = 1;
}

/************************************************************************/

void init_my_graphics()
{

  init_window( 10.0 );
  pv = &v;
  set_up_view( pv, -0.5, -0.05, 5.5, 0.55 );
  init_default_parameters( &sim );
  init_kin_dyn_parameters( &sim );
  reinit_display();
}

/************************************************************************/

void load_xt( MRDPLOT_DATA *d, int indx )
{
  xt[Q_X] = d->data[indx*d->n_channels + channels[HIP_X]];
  xt[Q_Z] = d->data[indx*d->n_channels + channels[HIP_Z]];
  xt[Q_PITCH] = d->data[indx*d->n_channels + channels[PITCH]];
  xt[Q_L_HIP] = d->data[indx*d->n_channels + channels[L_HIP]];
  xt[Q_L_KNEE] = d->data[indx*d->n_channels + channels[L_KNEE]];
  xt[Q_R_HIP] = d->data[indx*d->n_channels + channels[R_HIP]];
  xt[Q_R_KNEE] = d->data[indx*d->n_channels + channels[R_KNEE]];
}

/*****************************************************************************/

main( int argc, char **argv )
{
  char *filename;
  MRDPLOT_DATA *d;
  int i, j;
  float f;
  double x_offset;
  char * line = NULL;
  size_t len = 0;
  ssize_t read;

  if ( argc > 1 )
    filename = strdup( argv[1] );
  else
    filename = last_data();
  
  printf( "Reading: %s\n", filename );

  d = read_mrdplot( filename );

  channels[TIME] = find_channel( "time", d );
  channels[HIP_X] = find_channel( "x", d );
  if ( channels[HIP_X] < 0 )
      channels[HIP_X] = find_channel( "q_x", d );
  channels[HIP_Z] = find_channel( "z", d );
  if ( channels[HIP_Z] < 0 )
      channels[HIP_Z] = find_channel( "q_z", d );
  if ( channels[HIP_Z] < 0 )
      channels[HIP_Z] = find_channel( "y", d );
  channels[PITCH] = find_channel( "pitch", d );
  if ( channels[PITCH] < 0 )
      channels[PITCH] = find_channel( "q_pitch", d );
  if ( channels[PITCH] < 0 )
      channels[PITCH] = find_channel( "q.pitch", d );
  channels[L_HIP] = find_channel( "l_hip", d );
  if ( channels[L_HIP] < 0 )
      channels[L_HIP] = find_channel( "q_l_hip", d );
  if ( channels[L_HIP] < 0 )
      channels[L_HIP] = find_channel( "q.left_hip", d );
  channels[R_HIP] = find_channel( "r_hip", d );
  if ( channels[R_HIP] < 0 )
      channels[R_HIP] = find_channel( "q_r_hip", d );
  if ( channels[R_HIP] < 0 )
      channels[R_HIP] = find_channel( "q.right_hip", d );
  channels[L_KNEE] = find_channel( "l_knee", d );
  if ( channels[L_KNEE] < 0 )
      channels[L_KNEE] = find_channel( "q_l_knee", d );
  if ( channels[L_KNEE] < 0 )
      channels[L_KNEE] = find_channel( "q.left_knee", d );
  channels[R_KNEE] = find_channel( "r_knee", d );
  if ( channels[R_KNEE] < 0 )
      channels[R_KNEE] = find_channel( "q_r_knee", d );
  if ( channels[R_KNEE] < 0 )
      channels[R_KNEE] = find_channel( "q.right_knee", d );

  load_xt( d, 0 );

  init_my_graphics();

  for( i = 0; i < d->n_points; i++ )
    {
      load_xt( d, i );
 display_stuff();
      for( f = 0.0; f < 100000.0; f += 1.0 )
	;
      erase_stuff();
    }

  i = 0;
  load_xt( d, i );
  display_stuff();
  for( ; ; )
    {
      printf( "%d: ", i );
      read = getline(&line, &len, stdin);
      if ( read <= 1 )
	i = i+1;
      else
	sscanf( line, "%d", &i );
      if ( i < 0 )
	i = 0;
      if ( i >= d->n_points )
	i = d->n_points - 1;
      erase_stuff();
      load_xt( d, i );
      display_stuff();
    }
  if (line)
    free(line);
}

/*****************************************************************************/
