/*****************************************************************************/
/*
  data.c: save data from simulation
*/
/*****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "../mrdplot/mrdplot.h"

#include "main.h"

/*****************************************************************************/

extern SIM sim;

/*****************************************************************************/

#define MAX_N_POINTS 100000
#define N_CHANNELS 59

int myindex = 0;
int n_points = 0;
float mydata[MAX_N_POINTS*N_CHANNELS];

#define MRDPLOT_L_HIP 0
#define MRDPLOT_L_KNEE 1
#define MRDPLOT_R_HIP 2
#define MRDPLOT_R_KNEE 3
#define MRDPLOT_L_HIP_D 4
#define MRDPLOT_L_KNEE_D 5
#define MRDPLOT_R_HIP_D 6
#define MRDPLOT_R_KNEE_D 7
#define MRDPLOT_L_HIPD 8
#define MRDPLOT_L_KNEED 9
#define MRDPLOT_R_HIPD 10
#define MRDPLOT_R_KNEED 11
#define MRDPLOT_L_HIPD_D 12
#define MRDPLOT_L_KNEED_D 13
#define MRDPLOT_R_HIPD_D 14
#define MRDPLOT_R_KNEED_D 15
#define MRDPLOT_X 16
#define MRDPLOT_Z 17
#define MRDPLOT_PITCH 18
#define MRDPLOT_XD 19
#define MRDPLOT_ZD 20
#define MRDPLOT_PITCHD 21
#define MRDPLOT_L_HIP_TORQUE 22
#define MRDPLOT_L_KNEE_TORQUE 23
#define MRDPLOT_R_HIP_TORQUE 24
#define MRDPLOT_R_KNEE_TORQUE 25
#define MRDPLOT_L_FOOT_X 26
#define MRDPLOT_L_FOOT_Z 27
#define MRDPLOT_R_FOOT_X 28
#define MRDPLOT_R_FOOT_Z 29
#define MRDPLOT_L_FOOT_FX 30
#define MRDPLOT_L_FOOT_FZ 31
#define MRDPLOT_R_FOOT_FX 32
#define MRDPLOT_R_FOOT_FZ 33
#define MRDPLOT_STATE 34
#define MRDPLOT_STATE_TIME 35
#define MRDPLOT_TIME 36
#define MRDPLOT_STEP_LENGTH 37
#define MRDPLOT_L_BODY_ABS_ANGLE 38
#define MRDPLOT_L_THIGH_ABS_ANGLE 39
#define MRDPLOT_L_CALF_ABS_ANGLE 40
#define MRDPLOT_R_BODY_ABS_ANGLE 41
#define MRDPLOT_R_THIGH_ABS_ANGLE 42
#define MRDPLOT_R_CALF_ABS_ANGLE 43
#define MRDPLOT_L_HIP_COMMAND 44
#define MRDPLOT_L_KNEE_COMMAND 45
#define MRDPLOT_R_HIP_COMMAND 46
#define MRDPLOT_R_KNEE_COMMAND 47
#define MRDPLOT_L_HIP_FEEDFORWARD 48
#define MRDPLOT_L_KNEE_FEEDFORWARD 49
#define MRDPLOT_R_HIP_FEEDFORWARD 50
#define MRDPLOT_R_KNEE_FEEDFORWARD 51
#define MRDPLOT_XDD 52
#define MRDPLOT_ZDD 53
#define MRDPLOT_PITCHDD 54
#define MRDPLOT_L_HIPDD 55
#define MRDPLOT_L_KNEEDD 56
#define MRDPLOT_R_HIPDD 57
#define MRDPLOT_R_KNEEDD 58

char *names[N_CHANNELS] = { "l_hip",
			    "l_knee",
			    "r_hip",
			    "r_knee",
			    "l_hip_d",
			    "l_knee_d",
			    "r_hip_d",
			    "r_knee_d",
			    "l_hipd",
			    "l_kneed",
			    "r_hipd",
			    "r_kneed",
			    "l_hipd_d",
			    "l_kneed_d",
			    "r_hipd_d",
			    "r_kneed_d",
			    "x",
			    "z",
			    "pitch",
			    "xd",
			    "zd",
			    "pitchd",
			    "l_hip_torque",
			    "l_knee_torque",
			    "r_hip_torque",
			    "r_knee_torque",
			    "l_foot_x",
			    "l_foot_z",
			    "r_foot_x",
			    "r_foot_z",
			    "l_foot_fx",
			    "l_foot_fz",
			    "r_foot_fx",
			    "r_foot_fz",
			    "state",
			    "state_time",
			    "time",
			    "step_length",
			     "l_body_abs_angle",
			     "l_thigh_abs_angle",
			     "l_calf_abs_angle",
			     "r_body_abs_angle",
			     "r_thigh_abs_angle",
			     "r_calf_abs_angle",
			    "l_hip_command",
			    "l_knee_command",
			    "r_hip_command",
			    "r_knee_command",
			    "l_hip_feedforward",
			    "l_knee_feedforward",
			    "r_hip_feedforward",
			    "r_knee_feedforward",
			    "xdd",
			    "zdd",
			    "pitchdd",
			    "l_hipdd",
			    "l_kneedd",
			    "r_hipdd",
			    "r_kneedd"  };


char *units[N_CHANNELS] = { "r",
			    "r",
			    "r",
			    "r",
			    "r",
			    "r",
			    "r",
			    "r",
			    "r/s",
			    "r/s",
			    "r/s",
			    "r/s",
			    "r/s",
			    "r/s",
			    "r/s",
			    "r/s",
			    "m",
			    "m",
			    "r",
			    "m/s",
			    "m/s",
			    "r/s",
			    "Nm",
			    "Nm",
			    "Nm",
			    "Nm",
			    "m",
			    "m",
			    "m",
			    "m",
			    "N",
			    "N",
			    "N",
			    "N",
			    "-",
			    "s",
			    "s",
			    "-" ,
			     "r",
			     "r",
			     "r",
			     "r",
			     "r",
			    "r",
			    "Nm",
			    "Nm",
			    "Nm",
			    "Nm",
			    "Nm",
			    "Nm",
			    "Nm",
			    "Nm",
			    "m/s^2",
			    "m/s^2",
			    "r/s^2",
			    "r/s^2",
			    "r/s^2",
			    "r/s^2",
			    "r/s^2" };

/*****************************************************************************/

int load_data( SIM *s, float *data, int indx )
{

  if ( indx < 0 || indx >= (MAX_N_POINTS-1)*N_CHANNELS )
    {
      fprintf( stderr, "bad indx in load_data: %d %d\n",
	       indx, (MAX_N_POINTS-1)*N_CHANNELS );
      exit( -1 );
    }
  data[indx + MRDPLOT_L_HIP] = s->hip_angle[LEFT];
  data[indx + MRDPLOT_L_KNEE] = s->knee_angle[LEFT];
  data[indx + MRDPLOT_R_HIP] = s->hip_angle[RIGHT];
  data[indx + MRDPLOT_R_KNEE] = s->knee_angle[RIGHT];
  data[indx + MRDPLOT_L_HIP_D] = s->hip_angle_d[LEFT];
  data[indx + MRDPLOT_L_KNEE_D] = s->knee_angle_d[LEFT];
  data[indx + MRDPLOT_R_HIP_D] = s->hip_angle_d[RIGHT];
  data[indx + MRDPLOT_R_KNEE_D] = s->knee_angle_d[RIGHT];
  data[indx + MRDPLOT_L_HIPD] = s->hip_angled[LEFT];
  data[indx + MRDPLOT_L_KNEED] = s->knee_angled[LEFT];
  data[indx + MRDPLOT_R_HIPD] = s->hip_angled[RIGHT];
  data[indx + MRDPLOT_R_KNEED] = s->knee_angled[RIGHT];
  data[indx + MRDPLOT_L_HIPD_D] = s->hip_angled_d[LEFT];
  data[indx + MRDPLOT_L_KNEED_D] = s->knee_angled_d[LEFT];
  data[indx + MRDPLOT_R_HIPD_D] = s->hip_angled_d[RIGHT];
  data[indx + MRDPLOT_R_KNEED_D] = s->knee_angled_d[RIGHT];
  data[indx + MRDPLOT_X] = s->hip[XX];
  data[indx + MRDPLOT_Z] = s->hip[ZZ];
  data[indx + MRDPLOT_PITCH] = s->pitch;
  data[indx + MRDPLOT_XD] = s->hipd[XX];
  data[indx + MRDPLOT_ZD] = s->hipd[ZZ];
  data[indx + MRDPLOT_PITCHD] = s->pitchd;
  data[indx + MRDPLOT_L_HIP_TORQUE] = s->hip_torque[LEFT];
  data[indx + MRDPLOT_L_KNEE_TORQUE] = s->knee_torque[LEFT];
  data[indx + MRDPLOT_R_HIP_TORQUE] = s->hip_torque[RIGHT];
  data[indx + MRDPLOT_R_KNEE_TORQUE] = s->knee_torque[RIGHT];
  data[indx + MRDPLOT_L_FOOT_X] = s->foot[LEFT][XX];
  data[indx + MRDPLOT_L_FOOT_Z] = s->foot[LEFT][ZZ];
  data[indx + MRDPLOT_R_FOOT_X] = s->foot[RIGHT][XX];
  data[indx + MRDPLOT_R_FOOT_Z] = s->foot[RIGHT][ZZ];
  data[indx + MRDPLOT_L_FOOT_FX] = s->gndforce[LEFT][XX];
  data[indx + MRDPLOT_L_FOOT_FZ] = s->gndforce[LEFT][ZZ];
  data[indx + MRDPLOT_R_FOOT_FX] = s->gndforce[RIGHT][XX];
  data[indx + MRDPLOT_R_FOOT_FZ] = s->gndforce[RIGHT][ZZ];
  data[indx + MRDPLOT_STATE] = s->controller_state;
  data[indx + MRDPLOT_STATE_TIME] = s->state_elapsed_time;
  data[indx + MRDPLOT_TIME] = s->time;
  data[indx + MRDPLOT_STEP_LENGTH] = s->step_length;
  data[indx + MRDPLOT_L_BODY_ABS_ANGLE] = s->body_abs_angle[LEFT];
  data[indx + MRDPLOT_L_THIGH_ABS_ANGLE] = s->thigh_abs_angle[LEFT];
  data[indx + MRDPLOT_L_CALF_ABS_ANGLE] = s->calf_abs_angle[LEFT];
  data[indx + MRDPLOT_R_BODY_ABS_ANGLE] = s->body_abs_angle[RIGHT];
  data[indx + MRDPLOT_R_THIGH_ABS_ANGLE] = s->thigh_abs_angle[RIGHT];
  data[indx + MRDPLOT_R_CALF_ABS_ANGLE] = s->calf_abs_angle[RIGHT];
  data[indx + MRDPLOT_L_HIP_COMMAND] = s->hip_command[LEFT];
  data[indx + MRDPLOT_L_KNEE_COMMAND] = s->knee_command[LEFT];
  data[indx + MRDPLOT_R_HIP_COMMAND] = s->hip_command[RIGHT];
  data[indx + MRDPLOT_R_KNEE_COMMAND] = s->knee_command[RIGHT];
  data[indx + MRDPLOT_L_HIP_FEEDFORWARD] = s->hip_feedforward[LEFT];
  data[indx + MRDPLOT_L_KNEE_FEEDFORWARD] = s->knee_feedforward[LEFT];
  data[indx + MRDPLOT_R_HIP_FEEDFORWARD] = s->hip_feedforward[RIGHT];
  data[indx + MRDPLOT_R_KNEE_FEEDFORWARD] = s->knee_feedforward[RIGHT];
  data[indx + MRDPLOT_XDD] = s->hipdd[XX];
  data[indx + MRDPLOT_ZDD] = s->hipdd[ZZ];
  data[indx + MRDPLOT_PITCHDD] = s->pitchdd;
  data[indx + MRDPLOT_L_HIPDD] = s->hip_angledd[LEFT];
  data[indx + MRDPLOT_L_KNEEDD] = s->knee_angledd[LEFT];
  data[indx + MRDPLOT_R_HIPDD] = s->hip_angledd[RIGHT];
  data[indx + MRDPLOT_R_KNEEDD] = s->knee_angledd[RIGHT];
}

/*****************************************************************************/
/*****************************************************************************/

int unload_data( float *data, int indx, SIM *s )
{

  if ( indx < 0 || indx >= (MAX_N_POINTS-1)*N_CHANNELS )
    {
      fprintf( stderr, "bad indx in unload_data: %d %d\n",
	       indx, (MAX_N_POINTS-1)*N_CHANNELS );
      exit( -1 );
    }
  s->hip_angle[LEFT] = data[indx + MRDPLOT_L_HIP];
  s->knee_angle[LEFT] = data[indx + MRDPLOT_L_KNEE];
  s->hip_angle[RIGHT] = data[indx + MRDPLOT_R_HIP];
  s->knee_angle[RIGHT] = data[indx + MRDPLOT_R_KNEE];
  s->hip_angle_d[LEFT] = data[indx + MRDPLOT_L_HIP_D];
  s->knee_angle_d[LEFT] = data[indx + MRDPLOT_L_KNEE_D];
  s->hip_angle_d[RIGHT] = data[indx + MRDPLOT_R_HIP_D];
  s->knee_angle_d[RIGHT] = data[indx + MRDPLOT_R_KNEE_D];
  s->hip_angled[LEFT] = data[indx + MRDPLOT_L_HIPD];
  s->knee_angled[LEFT] = data[indx + MRDPLOT_L_KNEED];
  s->hip_angled[RIGHT] = data[indx + MRDPLOT_R_HIPD];
  s->knee_angled[RIGHT] = data[indx + MRDPLOT_R_KNEED];
  s->hip_angled_d[LEFT] = data[indx + MRDPLOT_L_HIPD_D];
  s->knee_angled_d[LEFT] = data[indx + MRDPLOT_L_KNEED_D];
  s->hip_angled_d[RIGHT] = data[indx + MRDPLOT_R_HIPD_D];
  s->knee_angled_d[RIGHT] = data[indx + MRDPLOT_R_KNEED_D];
  s->hip[XX] = data[indx + MRDPLOT_X];
  s->hip[ZZ] = data[indx + MRDPLOT_Z];
  s->pitch = data[indx + MRDPLOT_PITCH];
  s->hipd[XX] = data[indx + MRDPLOT_XD];
  s->hipd[ZZ] = data[indx + MRDPLOT_ZD];
  s->pitchd = data[indx + MRDPLOT_PITCHD];
  s->hip_torque[LEFT] = data[indx + MRDPLOT_L_HIP_TORQUE];
  s->knee_torque[LEFT] = data[indx + MRDPLOT_L_KNEE_TORQUE];
  s->hip_torque[RIGHT] = data[indx + MRDPLOT_R_HIP_TORQUE];
  s->knee_torque[RIGHT] = data[indx + MRDPLOT_R_KNEE_TORQUE];
  s->foot[LEFT][XX] = data[indx + MRDPLOT_L_FOOT_X];
  s->foot[LEFT][ZZ] = data[indx + MRDPLOT_L_FOOT_Z];
  s->foot[RIGHT][XX] = data[indx + MRDPLOT_R_FOOT_X];
  s->foot[RIGHT][ZZ] = data[indx + MRDPLOT_R_FOOT_Z];
  s->gndforce[LEFT][XX] = data[indx + MRDPLOT_L_FOOT_FX];
  s->gndforce[LEFT][ZZ] = data[indx + MRDPLOT_L_FOOT_FZ];
  s->gndforce[RIGHT][XX] = data[indx + MRDPLOT_R_FOOT_FX];
  s->gndforce[RIGHT][ZZ] = data[indx + MRDPLOT_R_FOOT_FZ];
  s->controller_state = data[indx + MRDPLOT_STATE];
  s->state_elapsed_time = data[indx + MRDPLOT_STATE_TIME];
  s->time = data[indx + MRDPLOT_TIME];
  s->step_length = data[indx + MRDPLOT_STEP_LENGTH];
  s->body_abs_angle[LEFT] = data[indx + MRDPLOT_L_BODY_ABS_ANGLE];
  s->thigh_abs_angle[LEFT] = data[indx + MRDPLOT_L_THIGH_ABS_ANGLE];
  s->calf_abs_angle[LEFT] = data[indx + MRDPLOT_L_CALF_ABS_ANGLE];
  s->body_abs_angle[RIGHT] = data[indx + MRDPLOT_R_BODY_ABS_ANGLE];
  s->thigh_abs_angle[RIGHT] = data[indx + MRDPLOT_R_THIGH_ABS_ANGLE];
  s->calf_abs_angle[RIGHT] = data[indx + MRDPLOT_R_CALF_ABS_ANGLE];
  s->hip_command[LEFT] = data[indx + MRDPLOT_L_HIP_COMMAND];
  s->knee_command[LEFT] = data[indx + MRDPLOT_L_KNEE_COMMAND];
  s->hip_command[RIGHT] = data[indx + MRDPLOT_R_HIP_COMMAND];
  s->knee_command[RIGHT] = data[indx + MRDPLOT_R_KNEE_COMMAND];
  s->hip_feedforward[LEFT] = data[indx + MRDPLOT_L_HIP_FEEDFORWARD];
  s->knee_feedforward[LEFT] = data[indx + MRDPLOT_L_KNEE_FEEDFORWARD];
  s->hip_feedforward[RIGHT] = data[indx + MRDPLOT_R_HIP_FEEDFORWARD];
  s->knee_feedforward[RIGHT] = data[indx + MRDPLOT_R_KNEE_FEEDFORWARD];
  s->hipdd[XX] = data[indx + MRDPLOT_XDD];
  s->hipdd[ZZ] = data[indx + MRDPLOT_ZDD];
  s->pitchdd = data[indx + MRDPLOT_PITCHDD];
  s->hip_angledd[LEFT] = data[indx + MRDPLOT_L_HIPDD];
  s->knee_angledd[LEFT] = data[indx + MRDPLOT_L_KNEEDD];
  s->hip_angledd[RIGHT] = data[indx + MRDPLOT_R_HIPDD];
  s->knee_angledd[RIGHT] = data[indx + MRDPLOT_R_KNEEDD];
}

/*****************************************************************************/

int save_data( SIM *s )
{
  if ( n_points >= MAX_N_POINTS )
    return;
  load_data( s, mydata, myindex );
  myindex += N_CHANNELS;
  n_points++;
}

/*****************************************************************************/

write_the_mrdplot_file( SIM *s )
{
  MRDPLOT_DATA *d; 

  d = malloc_mrdplot_data( 0, 0 );
  d->filename = generate_file_name();
  d->n_channels = N_CHANNELS;
  d->n_points = n_points;
  d->total_n_numbers = d->n_channels*d->n_points;
  d->frequency = 1/s->time_step;
  d->data = mydata;
  d->names = names;
  d->units = units;

  write_mrdplot_file( d );
}

/*****************************************************************************/
