/************************************************************************/
/*
b1-parameters: parameters of Garth bipeds.
*/
/************************************************************************/

#include <stdio.h>
#include <math.h>

#include "main.h"

/************************************************************************/
/************************************************************************/
/*
Assume biped is standing.
CM is measured from joint above.
head and hip offset are measured with respect to Pelvis CM
knee and foot offset are measured with respect to Shin/Calf CM.

We are assuming the pelvis CM is at the hip joint.
*/
/************************************************************************/

void init_kin_dyn_parameters( SIM *s )
{
  int i;

  /* Garth biped 1 */
  s->torso_length = 0.1;
  s->pelvis_mass = 1.54;
  s->pelvis_I = 0.000645073978666667;
  s->thigh_length = 0.2032;
  s->thigh_cm = 0.0719666666666667;
  s->thigh_mass = 0.54;
  s->thigh_I = 0.000688684713466528;
  s->calf_length = 0.2032;
  s->calf_cm = 0.1016;
  s->calf_mass = 0.1;
  s->calf_I = 0.000349461666666667;

#ifdef COMMENT
  /* Garth biped 2, with biped2.c */
  s->pelvis_mass = 1.5; /* needs to be 2.6 */
  s->thigh_mass = 0.6435;
  s->calf_mass = 0.13; /* needs to be 0.215 */
  s->pelvis_I = 0.001; /* needs to be bigger */
  s->thigh_I = 0.00086;
  s->calf_I = 0.00106;
  s->thigh_length = 0.2032;
  s->thigh_cm = 0.0685;
  s->calf_length = 0.2254;
  s->calf_cm = 0.1127; /* Can't make this smaller than half calf length???
			with biped2.c */

  /* Garth biped 2, with biped2c.c */
  s->pelvis_mass = 2.6;
  s->thigh_mass = 0.6435;
  s->calf_mass = 0.215;
  s->pelvis_I = 1.0; /* increasing this seems to lead to a lot of sliding */
  s->thigh_I = 0.00086;
  s->calf_I = 0.00106;
  s->thigh_length = 0.2032;
  s->thigh_cm = 0.0685;
  s->calf_length = 0.2254;
  s->calf_cm = 0.0604;
#endif

  /* Garth biped 2, with biped2i.c */
  s->pelvis_mass = 2.6;
  s->thigh_mass = 0.6435;
  s->calf_mass = 0.215;
  s->pelvis_I = 1.0; /* 0.06 make this bigger */
  s->thigh_I = 0.00086;
  s->calf_I = 0.00106;
  s->thigh_length = 0.2032;
  s->thigh_cm = 0.0685;
  s->calf_length = 0.2254;
  s->calf_cm = 0.0604;

  for( i = 0; i < 3; i++ )
    {
      s->head_offset[i] = 0;
      s->hip_offset[i] = 0;
      s->knee_offset[i] = 0;
      s->foot_offset[i] = 0;
    }
  s->head_offset[ZZ] = s->torso_length;
  s->hip_offset[ZZ] = 0;
  s->knee_offset[ZZ] = s->calf_cm;
  s->foot_offset[ZZ] = -(s->calf_length - s->calf_cm);
}

/************************************************************************/
