/**
 * Robosapien class code
 * Contains useful functions/constants
 *
 * This is the code that I will update necessary, so try to avoid making
 * changes to this file.  Instead, override these functions in other files if
 * necesary.
 * 
 * Dan Cartoon
 *
 * Version 1 - 2005/11/16
 */
 
 import java.lang.*;
 import java.io.*;
 
 
public class Robosapien {
	
	/**
	 * Initialize and return a Robosapien object
	 * @param CommPort The COM number for the serial port
	 */
	 
	public Robosapien(int CommPort){
		 ss = new SimpleSerialNative(CommPort);  // The argument is the commport number.  
		 										 //There is no Comm0.	
		//ss = new SimpleSerialJava(CommPort);
	}
	
	/**
	 * Send a code to the Robosapien
	 * @param Code An integer containing the code, see below for possible code
	 * @return An integer: <ul><li>-1 for failure</li><br>
	 *						<li>The number sent by the BasicX for success</li>
	 *						<br>
	 *						<li>When reading sensors, this number indicates>/li>
	 *						which sensors have been hit
	 */
	 
	public static int sendCode(int Code){
    	byte[] byteArray;   // read any string from the serial port
		boolean success = false;
		String inputString = new String();
		byte tempByte;
		int maxTries = 20;
		int attempt = 0;
		int response = 0;
		int ackIndex = -1;
		
		String codeString = Integer.toString(Code);
		
		String ack = "ACK" + codeString;
		
		
		//When we query the sensors, we don't get back ACKCODE
		if(Code == 121){
			ack = "ACK";
		}
		
		
		do{
			ackIndex = -1;
			response = 0;
			
			if(!ss.writeMesg(Code))
				return 0;
			
			//Read from the serial port	
			try { Thread.sleep(200); } catch (InterruptedException e) {}
			byteArray = ss.readBytes();
			
			//Convert from a byte array to a String for convenience	
			for(int i=0;i < byteArray.length;i++){
	    		tempByte = byteArray[i];
	    		inputString += (char)tempByte;
	    	}
			
			
			ackIndex = inputString.lastIndexOf(ack);;
		    
		    //Check to see if we've gotten an ACK
		    if(ackIndex > -1){
		    
		    	//This will either get codeString, or the result of the 
		    	//sensor query.
		    	try{
		    	response = Integer.parseInt(
		    		inputString.substring(ackIndex+3));
		    	}	
		    
		    	catch ( NumberFormatException e){
		    		response = -1;
		    	}
		    	
		    	success = true;
		    }
		    attempt++;
		    
		}while((!success) && (attempt < maxTries));
		
		if(attempt == maxTries)
			return -1;
		
		return response;
	}
	

    
    /**
     * Get sensor hits, and set global variables appropriately
     */
     
    public static void sendGetSensors(){
    	int response = sendCode(Get_Sensors);

    	Left_Arm = false;
		Right_Arm = false;
		Left_Leg = false;
		Right_Leg = false;

    	if(response > 0){
    		
    		//The robot stores sensor hits as bits in 
    		//an integer, which is what is returned to the PC
    		
    		//Structure:
    		//|Right_Arm|Left_Arm|Right_Leg|Left_Leg|
    		
    		if( (response & 1) == 1 ){
    			Left_Leg = true;
    		}		
    			
    		if( (response>>1 & 1) == 1 ){
    			Right_Leg = true;
    		}

    			
    		if( (response>>2 & 1) == 1 ){
    			Left_Arm = true;
    		}

    			
    		if( (response>>3 & 1) == 1){
    			Right_Arm = true;
    		}
    
    	}
    }
	
	/**
	 * This variable is passed around for serial communciations.  Shouldn't be
	 * necessary to acces for most Robosapien coding
	 */
	 
	public static SimpleSerial ss;
	
	//These are when looking at the robot from the front
	
	/**
	 *True when left arm sensor has been activated
	 */
	public static boolean Left_Arm = false;
	/**
	 *True when right arm sensor has been activated
	 */
	public static boolean Right_Arm = false;
	/**
	 *True when left leg sensor has been activated
	 */
	public static boolean Left_Leg = false;
	/**
	 *True when right leg sensor has been activated
	 */
	public static boolean Right_Leg = false;
	

	public static int Dance  = 0xD4;     //Best Move Ever

	/**
	 * Send this code to get sensor readings
	 */
	public static int Get_Sensors  = 0x79;
		
	//Plain codes - Primary movements
		
	public static int Turn_Right  = 0x80;
	public static int Right_Arm_Up  = 0x81;
	public static int Right_Arm_Out  = 0x82;
	public static int Tilt_Body_Right  = 0x83;
	public static int Right_Arm_Down  = 0x84;
	public static int Right_Arm_In  = 0x85;
	
	public static int Walk_Forward  = 0x86;
	public static int Walk_Backward  = 0x87;
	
	public static int Turn_Left  = 0x88;
	public static int Left_Arm_Up  = 0x89;
	public static int Left_Arm_Out  = 0x8A;
	public static int Tilt_Body_Left  = 0x8B;
	public static int Left_Arm_Down  = 0x8C;
	public static int Left_Arm_In  = 0x8D;
	public static int Stop_Code  = 0x8E;
	
	//Green RS Codes - Secondary movements
	public static int Right_Turn_Step  = 0xA0;
	public static int Right_Hand_Thump  = 0xA1;
	public static int Right_Hand_Throw  = 0xA2;
	public static int Right_Hand_Pickup  = 0xA3;
	
	public static int Lean_Forward  = 0xAD;
	public static int Lean_Backward  = 0xA5;
	public static int Forward_Step  = 0xA6;
	public static int Backward_Step  = 0xA7;
	
	public static int Left_Turn_Step  = 0xA8;
	public static int Left_Hand_Thump  = 0xA9;
	public static int Left_Hand_Pickup  = 0xAC;
	
	public static int Reset  = 0xAE;
	
	//Orange commands - Mostly for fun
	
	public static int Burp  = 0xC2;
	public static int High_Five  = 0xC4;
	public static int Bulldozer  = 0xC6;
	public static int Oops  = 0xC7;
	public static int Whistle  = 0xCA;
	public static int Roar  = 0xCE;
	public static int Demo  = 0xD0;
	public static int Demo_One  = 0xD2;

}    
