/**
 *Another sample program.  This is the smallest program that will get
 *a response from the Robosapien
 *
 *@author Dan Cartoon 
 *
 *Version 1 - 2005/11/16
 */
 
import java.io.*;
import java.lang.*;
import java.net.*;

public class RoboServer{
	private static int SERVER_PORT = 30000;	
	
    public static void main(String[] args) throws InterruptedException {
	        
	    //Create a new Robosapien variable with the specified COM number    
	   	Robosapien myRobosapien = new Robosapien(8);  //COM number goes here
	   	ServerSocket server = null;
	   	Socket client = null;
	   	DataInputStream input = null;
		DataOutputStream output = null;
	   	int code = -1;
	   	
	   	// Create listening socket
		try{
			server = new ServerSocket(SERVER_PORT);
		}catch (IOException e){
			System.out.println("Could not listen on port " + SERVER_PORT);
			System.exit(-1);
		}

		System.out.println("Listening on port " + SERVER_PORT);
	   	
		while(true)
		{
			// Block until a client accepts
			try{
				client = server.accept();
				input = new DataInputStream(client.getInputStream());
				output = new DataOutputStream(client.getOutputStream());
			}catch (IOException e) {
				System.out.println("Accept failed");
				System.exit(-1);
			}

			// Now we have the client, start processing commands
			while(!client.isClosed())
			{
				try{
					code = input.readByte();
					code = code & 0xff;
				}catch (EOFException eof) {
					System.out.println("Client closed connection, re-listening");
					break;
				}catch (IOException e) {
					System.out.println(e);
					break;
				}

				System.out.println("Received code 0x" + Integer.toHexString(code) + ", running it");
				
				// Send code to Robosapien and wait 500ms
				myRobosapien.sendCode(code);				

				// Signal client we're ready to recieve more, value of signal doesn't matter
				try{
				    output.writeByte(0);
				} catch(IOException e) {
					System.out.println("Client closed connection, re-listening");
					break;
				}
			
			}

		}
	}
}
