#include <stdio.h>
#include <stdlib.h>
#include <Winsock2.h>

// Movement codes
#define DANCE             0xD4
#define GET_SENSORS       0x79
#define TURN_RIGHT        0x80
#define RIGHT_ARM_UP      0x81
#define RIGHT_ARM_OUT     0x82
#define TILT_BODY_RIGHT   0x83
#define RIGHT_ARM_DOWN    0x84
#define RIGHT_ARM_IN      0x85
#define WALK_FORWARD      0x86
#define WALK_BACKWARD     0x87
#define TURN_LEFT         0x88
#define LEFT_ARM_UP       0x89
#define LEFT_ARM_OUT      0x8A
#define TILT_BODY_LEFT    0x8B
#define LEFT_ARM_DOWN     0x8C
#define LEFT_ARM_IN       0x8D
#define STOP_CODE         0x8E
#define RIGHT_TURN_STEP   0xA0
#define RIGHT_HAND_THUMP  0xA1
#define RIGHT_HAND_THROW  0xA2
#define RIGHT_HAND_PICKUP 0xA3
#define LEAN_FORWARD      0xAD
#define LEAN_BACKWARD     0xA5
#define FORWARD_STEP      0xA6
#define BACKWARD_STEP     0xA7
#define LEFT_TURN_STEP    0xA8
#define LEFT_HAND_THUMP   0xA9
#define LEFT_HAND_PICKUP  0xAC
#define RESET             0xAE
#define BURP              0xC2
#define HIGH_FIVE         0xC4
#define BULLDOZER         0xC6
#define OOPS              0xC7
#define WHISTLE           0xCA
#define ROAR              0xCE
#define DEMO              0xD0
#define DEMO_ONE          0xD2


// Server defines
#define SERVER_NAME	"localhost" // Change this to whatever system you're running the Java code on
#define SERVER_PORT 30000

// Function prototypes
void run_program();
void sendCode(unsigned char code);

// CSAPP functions
void unix_error(char *msg);
SOCKET open_clientfd(char *hostname, int port);
SOCKET Open_clientfd(char *hostname, int port);
int Close(int fd);


// Globals
SOCKET server_fd;  // Descriptor to talk to the Java app

int main (int argc, char **argv)
{
    WSADATA wsaData;

    // Initialize WinSock
    if(WSAStartup(MAKEWORD(1, 1), &wsaData) != 0)
	{
		printf("Error starting WinSock\n");
		return 0;
    }

	// Connect to server
	if((server_fd = Open_clientfd(SERVER_NAME, SERVER_PORT)) < 0)
		return 0;

	printf("Talking to fd %d\n", server_fd);

	// Do stuff
	run_program();

    // Cleanup
	Close(server_fd);
    WSACleanup();

	return 0;
}


/*
 * YOUR CODE HERE
 */
void run_program()
{
	// Do stuff here

	/* Example. Trying to do a John Travolta dance move, but you might want
	 * to make the code wait for an action to complete before you run
	 * the next action, otherwise the Robosapien goes crazy. */
	while(1)
	{
	    sendCode(RIGHT_ARM_DOWN);
	    sendCode(RIGHT_ARM_IN);
	    sendCode(RIGHT_ARM_OUT);
	    sendCode(RIGHT_ARM_UP);
	}
}

/*
 * Send a code to the server and block until we recieve a response, letting
 * the Java code decide when it's ready to recieve the next command. The
 * response is thrown away.
 */
void sendCode(unsigned char code)
{
	send(server_fd, &code, 1, 0);
	recv(server_fd, &code, 1, 0);
}


/******** 15-213 CSAPP FUNCTIONS HACKED FOR WINSOCK ********/

void unix_error(char *msg) /* unix-style error */
{
    fprintf(stderr, "%s: %s\n", msg, strerror(errno));
}
/* $end unixerror */

void dns_error(char *msg) /* dns-style error */
{
    fprintf(stderr, "%s: DNS error %d\n", msg, h_errno);
}


SOCKET Open_clientfd(char *hostname, int port)
{
    SOCKET rc;

    if ((rc = open_clientfd(hostname, port)) < 0) {
	if (rc == -1)
	    unix_error("Open_clientfd Unix error");
	else
	    dns_error("Open_clientfd DNS error");
    }
    return rc;
}


int Close(int fd)
{
    if (shutdown(server_fd, SD_SEND) == SOCKET_ERROR)
	{
		printf("Error shutting down socket\n");
        return 0;
	}
    if (closesocket(server_fd) == SOCKET_ERROR)
	{
		printf("Error closing socket\n");
        return 0;
	}

	return 1;
}


/*
 * open_clientfd - open connection to server at <hostname, port>
 *   and return a socket descriptor ready for reading and writing.
 *   Returns -1 and sets errno on Unix error.
 *   Returns -2 and sets h_errno on DNS (gethostbyname) error.
 */
/* $begin open_clientfd */
SOCKET open_clientfd(char *hostname, int port)
{
    SOCKET clientfd;
    struct hostent *hp;
    struct sockaddr_in serveraddr;

    if ((clientfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	return -1; /* check errno for cause of error */

    /* Fill in the server's IP address and port */
    if ((hp = gethostbyname(hostname)) == NULL)
	return -2; /* check h_errno for cause of error */
    memset(&serveraddr, 0, sizeof(serveraddr));
    serveraddr.sin_family = AF_INET;
	serveraddr.sin_addr.s_addr = *((u_long *)hp->h_addr);
    serveraddr.sin_port = htons((u_short)port);

    /* Establish a connection with the server */
    if (connect(clientfd, (struct sockaddr *) &serveraddr, sizeof(serveraddr)) < 0)
	return -1;
    return clientfd;
}
/* $end open_clientfd */
