function [xdd thdd] = twip( th, thd, trq,  m_w, r_w, I_w, m_p, l_p, I_p, g )
% compute a two wheeled inverted pendulum's forward dynamics
% State vector is [x body_angle x_velocity body_angular_velocity ]
%  Compute the "mass" matrix:
e1 = I_w/r_w^2 + m_p + m_w;
e2 = l_p*m_p*cos(th);
e3 = (I_p + l_p^2*m_p);
M = [ e1  e2
      e2  e3 ];
Minv = inv(M);
v = [ (-trq/r_w + thd^2*l_p*m_p*sin(th)) (trq + g*l_p*m_p*sin(th)) ];
rhs = transpose( v );
result = Minv*rhs;
xdd = result(1);
thdd = result(2);
end
