% Simulate a two wheeled inverted pendulum (Segway-like)
% State variables are encoders (wheel angle relative to body) and
% body angle relative to vertical
% State vector is [x body_angle x_velocity body_angular_velocity ]

global first_time
global r_w

if first_time
 m_w = 2.51327; % kg
 m_p = 20; % kg
 l_p = 1; % m
 I_w = 0.0502655;
 I_p = 6.68333;
 r_w = 0.2; % m
 g = 9.81; % m/s^2
 Kc = [ 1.0 60.0 1.0 10.0 ];
 goal = [ 0 0 0 0 ];
 samples_per_second = 333;
 duration = 20;
% initial state
x_initial = transpose( [ 0 0.8 0 0 ] );
% x_initial = transpose( [ 2 0 0 0 ] );
 first_time = 0;
end

N = round(duration*samples_per_second);
dt = duration/N;

score = 0;

% set up arrays
% x_array = zeros(N,4); % states
% u_array = zeros(N,1); % commands
% a_array = zeros(N,2); % acceleration
% e_array = zeros(N,1); % energy

% initial conditions
xx = x_initial;

init_plots( xx, N, r_w, l_p );

aa = [ 0 0 ];

% simulation
for i = 1:N
  x_array(i,:) = transpose( xx );
  uu = -Kc*xx;
%  uu = 0;
  u_array(i,1) = uu;

% Energy check
 th = xx(2);
 dx = xx(3);
 dth = xx(4);
 energy = (I_p*dth^2)/2 + (dx^2*m_p)/2 + (dx^2*(m_w*r_w^2 + I_w))/(2*r_w^2) + (dth^2*l_p^2*m_p)/2 + g*l_p*m_p*cos(th) + dth*dx*l_p*m_p*cos(th);
 e_array(i,1) = energy;
 debug_array(i,1) = xx(1) + l_p*sin(xx(2));
 debug_array(i,2) = l_p*cos(xx(2));
 debug_array(i,3) = l_p*sin(xx(2));
 debug_array(i,4) = atan2(sin(xx(2)),cos(xx(2)));

 [xdd thdd] = twip( xx(2), xx(4), uu, m_w, r_w, I_w, m_p, l_p, I_p, g );
 aa = [xdd thdd];
  a_array(i,:) = transpose( aa );
 if ( i < N )
   for j = 1:2
     vv_new(j) = xx(j+2) + aa(j)*dt;
     xx(j) = xx(j) + 0.5*(vv_new(j) + xx(j+2))*dt;
     xx(j+2) = vv_new(j);
   end
  % apply one step cost here.
  % score = score + dt*((xx(i) - goal)*(xx(i) - goal) + 0.05*uu(i)*uu(i));
 else
  % apply terminal state penalty here.
  % score = score + dt*((xx(i) - goal)*(xx(i) - goal));
 end
 % if ( rem( i, 2 ) == 0 )
   plot_it( xx, i, r_w, l_p );
 % end
% if ( rem( i, samples_per_second ) == 0 )
%   i
% end
  if ( abs(xx(2)) > 1.5 )
    break;
end
end

figure(2)
plot(x_array(:,1));
title( 'x' )

figure(3)
plot(x_array(:,2));
title( 'angle' )

figure(4)
plot(x_array(:,3));
title( 'x velocity' )

figure(5)
plot(x_array(:,4));
title( 'angular velocity' )

figure(6)
plot(u_array(:,1));
title( 'torque' )

figure(7)
plot(a_array(:,1));
title( 'x acceleration' )

figure(8)
plot(a_array(:,2));
title( 'body angular acceleration' )

figure(9)
plot(e_array(:,1));
title( 'energy' )

figure(1)

% To zoom in on a plot
% axis([0 10000 -0.01 0.01])
