global Ts

Ts = 0.005; % sampling interval

state = [ 0 0 ]; % initial state
command = 0; % initial command
duration = 5.0; % how long to simulate in seconds

n_points = duration/Ts  % simulate for duration seconds

% allocate a data array
data(n_points,4) = 0;

for i = 1:n_points
  command = control( state, i );
  % stash data
  data(i,1) = i*Ts; % time in seconds
  data(i,2) = state(1);
  data(i,3) = state(2);
  data(i,4) = command;
  % compute next state
  [ angle, angular_velocity ] = model( state, command );
  state(1) = angle;
  state(2) = angular_velocity;
end

figure(1)
plot(data(:,1),data(:,2));
title( 'angle vs. time' );
xlabel( 'seconds' );
ylabel( 'radians' );
  
figure(2)
plot(data(:,1),data(:,3));
title( 'angular velocity vs. time' );
xlabel( 'seconds' );
ylabel( 'radians/second' );

figure(3)
plot(data(:,1),data(:,4));
title( 'command' );
xlabel( 'seconds' );
ylabel( 'command units' );
