#include "Motor.h"

Motor Motor;

/*You can set the speed: 0~255 */
#define SPEED 150

char strbuf[][50]={
                    "Forward:encoder_count_right_a:",
                    "Forward:encoder_count_left_a:",
                    "Back:encoder_count_right_a:",
                    "Back:encoder_count_left_a:",
                    "Left:encoder_count_right_a:",
                    "Left:encoder_count_left_a:",
                    "Right:encoder_count_right_a:",
                    "Right:encoder_count_left_a:"
                   };

static bool go = false;  /* motor enable */
static int count = 0;    /* how long have we been running? Safety feature */

void setup() 
{
  // set pin to input with a pullup
  pinMode( ENCODER_RIGHT_A_PIN, INPUT_PULLUP );

  Serial.begin(115200);
  delay( 1000 );
  Serial.println("Encoder test.");
  delay( 1000 );
  Motor.Pin_init();
  Serial.println("Motor.Pin_init done.");
  delay( 1000 );
  Motor.Encoder_init();
  Serial.println( "encoder_init done." );
  Serial.println( "Wheels should be off the ground."  );
  Serial.println( "Type g <return> to run test, s <return> to stop."  );
  Serial.println( "Typing window is at the top of the serial monitor window" );
}

void ProcessCommand()
{

  if ( Serial.available() <= 0 )
    return;

  int c = Serial.read();

  if ( !go && ( c == 'G' || c == 'g' ) )
    {
        Serial.println( "Go!" );
        go = 1;
	count = 0;
    }
  else // To be conservative, typing anything will stop it.
    {  
        Serial.println( "Stop!" );
        go = 0;
        count = 0;
    }
}

void loop()
{
  ProcessCommand();

  if ( !go )
    {
      Motor.Stop();
      return;
    }

  // Turn off after a few iterations to keep from running forever
  if ( go && count > 4 )
    {
      Motor.Stop();
      Serial.println( "Motor stopped." );
      Serial.println( "Wheels should be off the ground."  );
      Serial.println( "Type g <return> to run test, s <return> to stop."  );
      go = false;
      count = 0;
      return;
    }

  Serial.print("Loop: ");
  Serial.println( count++ );
  for(int i = 0,j=0; i < 4,j<8; i++)
    {
      (Motor.*(Motor.MOVE[i]))(SPEED);
      delay(2000);
      Serial.print(strbuf[j++]);
      Serial.println(Motor.encoder_count_right_a);
      Serial.print(strbuf[j++]);
      Serial.println(Motor.encoder_count_left_a);
      Motor.encoder_count_right_a=0;
      Motor.encoder_count_left_a=0;
    }
}
