/*
This program turns on the green LED on the Elegoo Tumbller Nano board when
the right wheel is turned. The total encoder counts are printed on both
encoders. This is based on the PinChangeInterrupt library and the example
program PinChangeInterrupt_LED.

Note that only one wire is connected from each encoder, so we can't figure
out direction.

Chris Atkeson Mon 07 Feb 2022 11:35:31 PM EST

  Copyright (c) 2014-2015 NicoHood
  See the readme for credit to other people.

  PinChangeInterrupt_TickTock
  Demonstrates how to use the library

  Connect a button/cable to pin 7 anGradient descent.gifd ground.
  The Led state will change if the pin state does.

  PinChangeInterrupts are different than normal Interrupts.
  See readme for more information.
  Dont use Serial or delay inside interrupts!
  This library is not compatible with SoftSerial.

  The following pins are usable for PinChangeInterrupt:
  Arduino Uno/Nano/Mini: All pins are usable
  Arduino Mega: 10, 11, 12, 13, 50, 51, 52, 53, A8 (62), A9 (63), A10 (64),
              A11 (65), A12 (66), A13 (67), A14 (68), A15 (69)
  Arduino Leonardo/Micro: 8, 9, 10, 11, 14 (MISO), 15 (SCK), 16 (MOSI)
  HoodLoader2: All (broken out 1-7) pins are usable
  Attiny 24/44/84: All pins are usable
  Attiny 25/45/85: All pins are usable
  Attiny 13: All pins are usable
  Attiny 441/841: All pins are usable
  ATmega644P/ATmega1284P: All pins are usable
*/

#include "PinChangeInterrupt.h"

#define ENCODER_LEFT_A_PIN 2
#define ENCODER_RIGHT_A_PIN 4

volatile unsigned long int left_encoder_count = 0;
volatile unsigned long int right_encoder_count = 0;

void left_encoder_isr( void )
{
  left_encoder_count++;
}

void right_encoder_isr( void )
{
  // Switch Led state
  digitalWrite( LED_BUILTIN, !digitalRead(LED_BUILTIN) );
  right_encoder_count++;
}

void setup()
{
  // set pin to input with a pullup, led to output
  pinMode( ENCODER_RIGHT_A_PIN, INPUT_PULLUP );
  pinMode( LED_BUILTIN, OUTPUT );

  Serial.begin(115200);
  Serial.print("Encoder test.");
  Serial.println();
  delay(1000); // give output a chance to print.

  // Left encoder is coming in on pin 2 which is an "interrupt" pin,
  // and attachInterrup() works
  attachInterrupt( digitalPinToInterrupt( ENCODER_LEFT_A_PIN ), left_encoder_isr, CHANGE);
  Serial.print("Left encoder init done.");
  Serial.println();
  delay(1000); // give output a chance to print.

  // Right encoder is coming in on pin 4 which is not an "interrupt" pin.
  // Attach PinChangeInterrupt instead.
  attachPCINT( digitalPinToPCINT( ENCODER_RIGHT_A_PIN ), right_encoder_isr, CHANGE );
  Serial.print("Right encoder init done.");
  Serial.println();
  delay(1000); // give output a chance to print.
}

void loop()
{
  Serial.print( "encoders: " );
  Serial.print( left_encoder_count );
  Serial.print( " " );
  Serial.print( right_encoder_count );
  Serial.println();
  delay(1000);
}
