// You can safely ignore this code

/*****************************************
Timekeeping part */

      unsigned long current_micros = micros();
      if ( current_micros > last_micros )
        servo_time += current_micros - last_micros;
      else // rollover
        servo_time += (MAX_ULONG - last_micros) + current_micros;
      last_micros = current_micros;

      // It isn't time yet ...
      if ( servo_time < SERVO_INTERVAL )
        continue;

      // It is time! Reset the servo clock.
      servo_time -= SERVO_INTERVAL;

      // Keep track of maximum lateness
      if ( max_servo_late < servo_time )
        max_servo_late = servo_time;

      // Let's have some slop in counting late cycles.
      if ( servo_time > LATE_CYCLE_SLOP )
        servo_late += 1;
    
      // handle the millisecond clocks
      unsigned long current_millis = millis();
      int millis_increment;
      if ( current_millis > last_millis )
        millis_increment = current_millis - last_millis;
      else // rollover
        millis_increment = (MAX_ULONG - last_millis) + current_millis;
      last_millis = current_millis;
  
      run_time += millis_increment;
      debug_print_time += millis_increment;

/*****************************************
Administrative part */

      // Turn off after a while to keep from running forever
      if ( ( run_time > real_run_time_limit ) || ( !go ) )
        {
          motor_stop();
          ramp = 0;
          Serial.println( "Motor stopped." );
          Serial.println( "Wheels should be off the ground."  );
          Serial.println( "Type g <return> to run test, s <return> to stop." );
          return;
        }

/*****************************************
State estimation part */

      float left_prediction
      	    = a_vel_est*left_wheel_angular_velocity_encoder_estimated
	    + b_vel_est*left_command;

      unsigned long int the_raw_left_encoder_count = read_left_encoder();

      int left_increment  // this is always positive or zero
      	  = the_raw_left_encoder_count - last_raw_left_encoder_count;
	  last_raw_left_encoder_count = the_raw_left_encoder_count;

      float left_measured = 0;
      if ( left_prediction > 0 )
        left_measured = left_increment;
      else if ( left_prediction < 0 )
        left_measured = -left_increment;
      else if ( left_command > 0 )
        left_measured = left_increment;
      else if ( left_command < 0 )
        left_measured = -left_increment;
      else if ( left_wheel_angular_velocity_encoder_estimated > 0 )
        left_measured = left_increment;
      else if ( left_wheel_angular_velocity_encoder_estimated < 0 )
        left_measured = -left_increment;
      else
        left_measured = left_increment; // ran out of criteria to guide this
      left_wheel_angular_velocity_encoder_estimated
        = left_prediction + k_vel_est*(left_measured - left_prediction);
      left_wheel_angle_encoder_estimated
        += left_wheel_angular_velocity_encoder_estimated;

      left_wheel_angular_velocity_radians
        = ENCODER_VELOCITY_TO_RADIANS
	   *left_wheel_angular_velocity_encoder_estimated;
      left_wheel_angle_radians
        = ENCODER_TO_RADIANS*left_wheel_angle_encoder_estimated;

/*****************************************/

