clc;clear;close all;
%% Define generalized system variables:

syms x dx th dth trq 'real'
syms g m_p m_w l_p r_w I_p I_w 'real'

s = [x; th];
ds = [dx; dth];

% Locate center of mass of pendulum
% Pendulum 'arm' is a function of the pendulum angle, theta, and the cart
% position, x.
cm_p = [x + l_p*sin(th); l_p*cos(th)];

% Linear velocity of the pendulum
v_p = jacobian(cm_p, s)*ds;

% Angular velocity of the wheel
omega_w = dx/r_w;

% Energies
k_w = simplify( expand( 1/2 * m_w * dx^2 + 1/2 * I_w * omega_w^2 ) );
k_p = simplify( expand( 1/2 * m_p * (v_p)' * v_p + 1/2 * I_p * dth^2 ) );

p_w = 0;
p_p = m_p * g * l_p * cos(th);

% Lagrangian
L = k_w + k_p - p_w - p_p;

% External Forces (like joint torques)
Q = [-trq/r_w, trq];

% Compute Euler-Lagrange:
EQ = EulerLagrange(s,ds,L,Q,1); 

% Equations that result:
% ddx = -(r_w*(trq - dth^2*l_p*m_p*r_w*sin(th) + ddth*l_p*m_p*r_w*cos(th)))/(I_w + m_p*r_w^2 + m_w*r_w^2) 
% ddth = (trq - ddx*l_p*m_p*cos(th) + g*l_p*m_p*sin(th))/(I_p + l_p^2*m_p)

% Which matches mathematica and the notes on the web.

% M = ( ( I_w + m_p*r_w^2 + m_w*r_w^2 )  r_w*l_p*m_p*r_w*cos(th) )
%     ( l_p*m_p*cos(th)                  (I_p + l_p^2*m_p)       )        
   
% RHS:
% -r_w*(trq - dth^2*l_p*m_p*r_w*sin(th))
%  trq + g*l_p*m_p*sin(th))
