clc;clear;close all;
%% Define generalized system variables:
syms x y z dx dy dz ...
    phi psi theta dphi dpsi dtheta 'real'

% Position and velocity
p = [x; y; z];
dp = [dx; dy; dz];

% Euler angles and rates
eta = [phi; theta; psi];
d_eta = [dphi; dtheta; dpsi];

%% Define the rotation matrices W and R_BG
W = [1 0 -sin(theta)
    0 cos(phi) cos(theta)*sin(phi)
    0 -sin(phi) cos(theta)*cos(phi)];

Rx  = [1 0 0;...
    0 cos(phi) sin(phi) ;...
    0 -sin(phi) cos(phi)];

Ry  = [cos(theta) 0 -sin(theta);...
    0 1 0;...
    sin(theta) 0 cos(theta)];

Rz =  [cos(psi) sin(psi) 0;...
    -sin(psi) cos(psi) 0;...
    0 0 1];

R_BG = Rx*Ry*Rz;

%% Define forces, torque and inertial matrices // Quadrotor specific

syms T tau_phi tau_theta tau_psi...
    m g I_xx I_yy I_zz 'real'

T_B = [0; 0; T];
tau_B = [tau_phi; tau_theta; tau_psi];

I_B = [I_xx 0 0; 0 I_yy 0; 0 0 I_zz];
J = W'*I_B*W;

T_G = R_BG' * T_B;

%% Then we define the Lagrangian:
% This method requires the system to be described in terms of generalized
% coordinates 's' and its derivatives 'ds'

s = [p; eta];     % Position and euler angles
ds = [dp; d_eta]; % Velocity and angular rates

%Energies
E_trans = 1/2 * m * (dp)' * dp;
E_rot = 1/2 * (d_eta)' * J * d_eta;
E_pot = m * g * [0 0 1] * p;

%Lagrangian
L = E_trans + E_rot - E_pot;

%External Forces (like system inputs)
Q = [T_G; tau_B];

% Compute Euler-Lagrange:
%EQ = EulerLagrange(s,ds,L,Q); % prints nothing
EQ = EulerLagrange(s,ds,L,Q,1); % prints result
%EQ = EulerLagrange(s,ds,L,Q,2); % prints results and derivative terms




