clc;clear;close all;
%% Define generalized system variables:

syms x dx theta dtheta F 'real'
syms g m_pend m_cart l_pend J_pend 'real'

s = [theta; x;];
ds = [dtheta; dx];

% Pendulum 'arm' is a function of the pendulum angle, theta, and the cart
% position, x.
r_pend = [x - l_pend * sin(theta); l_pend * cos(theta)];

% Linear velocity component of the pendulum
v_pend = jacobian(r_pend, s) * ds;

% Pendulum inertia approximation (rod with length l_pend)
%J_pend = m_pend * l_pend^2; % can be unsilenced

% Energies
E_trans = 1/2 * m_cart * dx^2 ...
        + 1/2 * m_pend * (v_pend)' * v_pend;
    
E_rot = 1/2 * J_pend * dtheta^2;

E_pot = m_pend * g * l_pend * cos(theta);

% Lagrangian
L = E_trans + E_rot - E_pot;

% External Forces (like system inputs)
Q = [sym(0); F];

% Compute Euler-Lagrange:
EQ = EulerLagrange(s,ds,L,Q,1); 





