clc; clear; close all;

%% Define generalized system variables:
syms m g y dy f 'real'

% Not much to do, the system is defined solely from the input 'f' 


%% Then we define the Lagrangian:
% This method requires the system to be described in terms of generalized
% coordinates 's' and its derivatives 'ds'

%Generalized coordinates and their derivatives
s = y;
ds = dy;

%Energies
E_trans = 1/2 * m * (dy)' * dy;
E_rot = 0;
E_pot = m * g * y;

%Lagrangian
L = E_trans + E_rot - E_pot;

%External Forces (like system inputs)
Q = f;

% Compute Euler-Lagrange:
EQ = EulerLagrange(s,ds,L,Q,true);



