function new_data = regress( data, filter_cutoff, Kalman_gain )
% build AA and BB matrics

global AA; % regress everything 
global AA2; % wheel model
global AA3; % body model
global AA4; % another model
global AA5; % another model
global BB;
global n_points;

Ts = 0.003;

% Use this filter
if filter_cutoff < 1.0 
[b_filter a_filter] = butter( 1, filter_cutoff );
else % no filter at all
  b_filter = [1];
  a_filter = [1];
end

% number of points in data
N = length(data);

wheel_angle = -filtfilt( b_filter, a_filter, pi*(data(:,2)+data(:,3))/1560 );

% estimate wheel velocity
wheel_velocity(N) = 0; % allocate velocity array
for ( i = 3:N )
  wheel_velocity(i-1) = (wheel_angle(i) - wheel_angle(i-2))/(2*Ts);
end
wheel_velocity(1) = wheel_velocity(2); % take care of ends
wheel_velocity(N) = wheel_velocity(N-1);

% estimate wheel acceleration
wheel_acceleration(N) = 0; % allocate velocity array
for ( i = 3:N )
  wheel_acceleration(i-1) = (wheel_angle(i) - 2*wheel_angle(i-1) + wheel_angle(i-2))/(Ts*Ts);
end
wheel_acceleration(1) = wheel_acceleration(2); % take care of ends
wheel_acceleration(N) = wheel_acceleration(N-1);

% pull out command array
commands = filtfilt( b_filter, a_filter, data(:,4) );

% body angle from accelerometers (very noisy)
body_angle_from_acc = filtfilt( b_filter, a_filter, atan2( data(:,6), data(:,7) ) );

gscale = 1.352011295799561e-04; % convert gyro to radians/second

body_velocity = filtfilt( b_filter, a_filter, gscale*data(:,8) );

% use Kalman filter to get better body angle
body_angle_from_kf = kf( Kalman_gain, body_angle_from_acc, body_velocity );

% estimate body_acceleration
body_acceleration(N) = 0; % allocate velocity array
for ( i = 3:N )
  body_acceleration(i-1) = (body_velocity(i) - body_velocity(i-2))/(2*Ts);
end
body_acceleration(1) = body_acceleration(2); % take care of ends
body_acceleration(N) = body_acceleration(N-1);

sim_wheel_ang(N) = 0;
sim_wheel_vel(N) = 0;
sim_wheel_ang(1) = wheel_angle(1);
sim_wheel_vel(1) = wheel_velocity(1);

for i = 2:N
  sim_wheel_ang(i) = sim_wheel_ang(i-1) + Ts*sim_wheel_vel(i-1);
  sim_wheel_vel(i) = 0.96*sim_wheel_vel(i-1) + 0.004*commands(i-1);
end

sim_body_ang(N) = 0;
sim_body_vel(N) = 0;
% skip launch
start = 75;
sim_body_ang(1:start) = body_angle_from_kf(start);
sim_body_vel(1:start) = body_velocity(start);

sum_vel_err2 = 0;
for i = (start+1):N
  sim_body_ang(i) = sim_body_ang(i-1) + Ts*sim_body_vel(i-1);
  sim_body_vel(i) = -0.54*sin(sim_body_ang(i-1)) + 0.94*sim_body_vel(i-1) + 0.001*commands(i-6);
  sum_vel_err2 = sum_vel_err2 + (sim_body_vel(i) - body_velocity(i))^2;
end
sum_vel_err2;

%weight = N;
%weight = sqrt( N );
weight = 1;

% run simulation
xx(1) = wheel_angle(1);
xx(2) = wheel_velocity(1);
xx(3) = body_angle_from_kf(1);
xx(4) = body_velocity(1);
for i=1:(N-1)
 xx_array(i,:) = xx;
 [wdd thdd] = twip2( xx(3), xx(4), commands(i), xx(2) );
 aa = [wdd thdd];
    % integrate wheel stuff
   vv_new = xx(2) + aa(1)*Ts;
   xx(1) = xx(1) + 0.5*(vv_new + xx(2))*Ts;
   xx(2) = vv_new;
   % integrate body angle stuff
   vv_new = xx(4) + aa(2)*Ts;
   xx(3) = xx(3) + 0.5*(vv_new + xx(4))*Ts;
   xx(4) = vv_new;
 end
xx_array(N,:) = xx;

for i = 3:(N-2)
  n_points = n_points + 1;
  AA( n_points, 1 ) = weight*wheel_angle(i);
  AA( n_points, 2 ) = weight*wheel_velocity(i);
  AA( n_points, 3 ) = weight*body_angle_from_kf(i);
  AA( n_points, 4 ) = weight*body_velocity(i);
  AA( n_points, 5 ) = weight*commands(i);
  AA( n_points, 6 ) = weight*sign(wheel_velocity(i));
  AA( n_points, 7 ) = weight;

  AA2( n_points, 1 ) = weight*wheel_angle(i);
  AA2( n_points, 2 ) = weight*wheel_velocity(i);
  AA2( n_points, 3 ) = weight*commands(i);

  AA3( n_points, 1 ) = weight*body_angle_from_kf(i);
  AA3( n_points, 2 ) = weight*body_velocity(i);
  AA3( n_points, 3 ) = weight*commands(i);

  AA4( n_points, 1 ) = weight*wheel_velocity(i);
  AA4( n_points, 2 ) = weight*body_angle_from_kf(i);
  AA4( n_points, 3 ) = weight*body_velocity(i);
  AA4( n_points, 4 ) = weight*commands(i);

  AA5( n_points, 1 ) = weight*wheel_velocity(i);
  AA5( n_points, 2 ) = weight*body_angle_from_kf(i);
  AA5( n_points, 3 ) = weight*body_velocity(i);
  AA5( n_points, 4 ) = weight*commands(i);
  AA5( n_points, 5 ) = weight*sign(wheel_velocity(i));
  AA5( n_points, 6 ) = weight;

  BB( n_points, 1 ) = weight*wheel_angle(i+1);
  BB( n_points, 2 ) = weight*wheel_velocity(i+1);
  BB( n_points, 3 ) = weight*body_angle_from_kf(i+1);
  BB( n_points, 4 ) = weight*body_velocity(i+1);
end

new_data = data;

[nr nc] = size(data);

% 1 timestamps
% 2 left wheel encoder
% 3 right wheel encoder
% 4 left command
% 5 right command
% 6 Y accelerometer
% 7 Z accelerometer
% 8 gyro
% 9 online KF in Y acc. units
% 10 body angle from atan2( Y acc, X acc )
new_data(:,nc+1) = body_angle_from_acc;
% 11 filtered wheel radians
new_data(:,nc+2) = wheel_angle;
% 12 wheel angular velocity (rad/sec)
new_data(:,nc+3) = wheel_velocity;
% 13 wheel angular acceleration (rad/sec^2)
new_data(:,nc+4) = wheel_acceleration;
% 14 accelerometer angle in radians
new_data(:,nc+5) = body_angle_from_kf;
% 15 gryo radians/second
new_data(:,nc+6) = body_velocity;
% 16 body angular acceleration radians/(second^2)
new_data(:,nc+7) = body_acceleration;
% 17 simulated wheel angle (radians)
new_data(:,nc+8) = sim_wheel_ang;
% 18 simulated wheel angular velocity (radians/second)
new_data(:,nc+9) = sim_wheel_vel;
% 19 simulated body angle (radians)
new_data(:,nc+10) = sim_body_ang;
% 20 simulated body angular velocity (radians/second)
new_data(:,nc+11) = sim_body_vel;
% 21 sim2_wheel_angle
new_data(:,nc+12) = xx_array(:,1);
% 22 sim2_wheel_angular_velocity
new_data(:,nc+13) = xx_array(:,2);
% 23 sim2_body_angle
new_data(:,nc+14) = xx_array(:,3);
% 24 sim2_body_angular_velocity
new_data(:,nc+15) = xx_array(:,4);

% note to self
ascale = 5.575380291904716e-05;
