figure(1)
plot(ff000(:,12))
hold
plot(ff000(:,18))
legend('actual wheel velocity','simulated wheel velocity') 
title('actual vs. simulated wheel velocity, based on integrated motor command v-next = 0.96*v + 0.004*u)')


figure(2)
plot(ff000(:,11))
hold
plot(ff000(:,17))
legend('actual wheel angle','simulated wheel angle')      
title('actual vs. simulated wheel angle, based on integrated wheel velocity (angle-next = angle + Ts*angular-velocity)')

figure(3)
[b a] = butter(1,0.2)          
plot(filtfilt(b,a,ff000(:,13)))
hold
plot(ff000(:,4))    
legend('filtered wheel acceleration','command')              
title('Filtered wheel acceleration (filtfilt, butter(1,0.2)) and command')

