function new_data = regress( data, filter_cutoff, Kalman_gain )
% build AA and BB matrics

global AA; % regress everything 
global AA2; % wheel model
global AA3; % body model
global AA4; % another model
global AA5; % another model
global BB;
global n_points;

% Use this filter
if filter_cutoff < 1.0 
[b_filter a_filter] = butter( 1, filter_cutoff );
else % no filter at all
  b_filter = [1];
  a_filter = [1];
end

Ts = 0.003;

% number of points in data
N = length(data);

wheel_angle = filtfilt( b_filter, a_filter, pi*(data(:,2)+data(:,3))/1560 );

% estimate wheel velocity
wheel_velocity(N) = 0; % allocate velocity array
for ( i = 3:N )
  wheel_velocity(i-1) = (wheel_angle(i) - wheel_angle(i-2))/(2*Ts);
end
wheel_velocity(1) = wheel_velocity(2); % take care of ends
wheel_velocity(N) = wheel_velocity(N-1);

% estimate wheel acceleration
wheel_acceleration(N) = 0; % allocate velocity array
for ( i = 3:N )
  wheel_acceleration(i-1) = (wheel_angle(i) - 2*wheel_angle(i-1) + wheel_angle(i-2))/(Ts*Ts);
end
wheel_acceleration(1) = wheel_acceleration(2); % take care of ends
wheel_acceleration(N) = wheel_acceleration(N-1);

% pull out command array
commands = filtfilt( b_filter, a_filter, data(:,4) );

% body angle from accelerometers (very noisy)
body_angle_from_acc = filtfilt( b_filter, a_filter, atan2( data(:,6), data(:,7) ) );

gscale = 1.352011295799561e-04; % convert gyro to radians/second

body_velocity = filtfilt( b_filter, a_filter, gscale*data(:,8) );

% use Kalman filter to get better body angle
body_angle_from_kf = kf( Kalman_gain, body_angle_from_acc, body_velocity );

% estimate body_acceleration
body_acceleration(N) = 0; % allocate velocity array
for ( i = 3:N )
  body_acceleration(i-1) = (body_velocity(i) - body_velocity(i-2))/(2*Ts);
end
body_acceleration(1) = body_acceleration(2); % take care of ends
body_acceleration(N) = body_acceleration(N-1);

% simulate body angle and angular velocity
% 1 0.003 0     0       0
% 0 0.96  0.1  -0.03   0.004
% 0 0     1     0.003   0
% 0 0     -0.45 0.98    0.00017 -vs. -0.0016

sim_wheel_ang(N) = 0;
sim_wheel_vel(N) = 0;
sim_wheel_ang(1) = wheel_angle(1);
sim_wheel_vel(1) = wheel_velocity(1);

for i = 2:N
  sim_wheel_ang(i) = sim_wheel_ang(i-1) + Ts*sim_wheel_vel(i-1);
  sim_wheel_vel(i) = 0.96*sim_wheel_vel(i-1) + 0.004*commands(i-1);
end

sim_body_ang(N) = 0;
sim_body_vel(N) = 0;
sim_body_ang(1) = body_angle_from_kf(1);
sim_body_vel(1) = body_velocity(1);

for i = 2:N
  sim_body_ang(i) = sim_body_ang(i-1) + Ts*sim_body_vel(i-1);
sim_body_vel(i) = -0.45*sim_body_ang(i-1) + 0.92*sim_body_vel(i-1) + 0.0001*commands(i-1) + 0.02*wheel_velocity(i);
end

%weight = N;
%weight = sqrt( N );
weight = 1;

for i = 3:(N-2)
  n_points = n_points + 1;
  AA( n_points, 1 ) = weight*wheel_angle(i);
  AA( n_points, 2 ) = weight*wheel_velocity(i);
  AA( n_points, 3 ) = weight*body_angle_from_kf(i);
  AA( n_points, 4 ) = weight*body_velocity(i);
  AA( n_points, 5 ) = weight*commands(i);
  AA( n_points, 6 ) = weight*sign(wheel_velocity(i));
  AA( n_points, 7 ) = weight;

  AA2( n_points, 1 ) = weight*wheel_angle(i);
  AA2( n_points, 2 ) = weight*wheel_velocity(i);
  AA2( n_points, 3 ) = weight*commands(i);

  AA3( n_points, 1 ) = weight*body_angle_from_kf(i);
  AA3( n_points, 2 ) = weight*body_velocity(i);
  AA3( n_points, 3 ) = weight*commands(i);

  AA4( n_points, 1 ) = weight*wheel_velocity(i);
  AA4( n_points, 2 ) = weight*body_angle_from_kf(i);
  AA4( n_points, 3 ) = weight*body_velocity(i);
  AA4( n_points, 4 ) = weight*commands(i);

  AA5( n_points, 1 ) = weight*wheel_velocity(i);
  AA5( n_points, 2 ) = weight*body_angle_from_kf(i);
  AA5( n_points, 3 ) = weight*body_velocity(i);
  AA5( n_points, 4 ) = weight*commands(i);
  AA5( n_points, 5 ) = weight*sign(wheel_velocity(i));
  AA5( n_points, 6 ) = weight;

  BB( n_points, 1 ) = weight*wheel_angle(i+1);
  BB( n_points, 2 ) = weight*wheel_velocity(i+1);
  BB( n_points, 3 ) = weight*body_angle_from_kf(i+1);
  BB( n_points, 4 ) = weight*body_velocity(i+1);
end

new_data = data;

[nr nc] = size(data);

% 1 timestamps
% 2 left wheel encoder
% 3 right wheel encoder
% 4 left command
% 5 right command
% 6 Y accelerometer
% 7 Z accelerometer
% 8 gyro
% 9 online KF in Y acc. units
% 10 body angle from atan2( Y acc, X acc )
new_data(:,nc+1) = body_angle_from_acc;
% 11 filtered wheel radians
new_data(:,nc+2) = wheel_angle;
% 12 wheel angular velocity (rad/sec)
new_data(:,nc+3) = wheel_velocity;
% 13 wheel angular acceleration (rad/sec^2)
new_data(:,nc+4) = wheel_acceleration;
% 14 accelerometer angle in radians
new_data(:,nc+5) = body_angle_from_kf;
% 15 gryo radians/second
new_data(:,nc+6) = body_velocity;
% 16 body angular acceleration radians/(second^2)
new_data(:,nc+7) = body_acceleration;
% 17 simulated wheel angle (radians)
new_data(:,nc+8) = sim_wheel_ang;
% 18 simulated wheel angular velocity (radians/second)
new_data(:,nc+9) = sim_wheel_vel;
% 19 simulated body angle (radians)
new_data(:,nc+10) = sim_body_ang;
% 20 simulated body angular velocity (radians/second)
new_data(:,nc+11) = sim_body_vel;

% note to self
ascale = 5.575380291904716e-05;
