#include "Motor.h"
#include "PinChangeInterrupt.h"

static void EncoderCountRightA();
static void EncoderCountLeftA();

void Motor::Encoder_init()
{
  Serial.print( "Encoder_init " );
  Serial.print( ENCODER_LEFT_A_PIN );
  Serial.print( " " );
  Serial.print( digitalPinToInterrupt(ENCODER_LEFT_A_PIN) );
  Serial.print( " " );
  Serial.print( ENCODER_RIGHT_A_PIN );
  Serial.print( " " );
  Serial.print( digitalPinToInterrupt(ENCODER_RIGHT_A_PIN) );
  Serial.println();
  delay(1000);
  // Left encoder is coming in on pin 2 which is an "interrupt" pin,
  // and attachInterrup() works
  attachInterrupt(digitalPinToInterrupt(ENCODER_LEFT_A_PIN), EncoderCountLeftA, CHANGE);
  Serial.print( "left encoder ISR set" );
  Serial.println();
  delay(1000);
  // Right encoder is coming in on pin 4 which is not an "interrupt" pin.
  // Attach PinChangeInterrupt instead.
  attachPCINT( digitalPinToPCINT( ENCODER_RIGHT_A_PIN ), EncoderCountRightA,
               CHANGE );
  Serial.print( "right encoder ISR set" );
  Serial.println();
  delay(1000);
}

unsigned long Motor::encoder_count_right_a;
//Getting right wheel speed.
static void EncoderCountRightA()
{
  Motor::encoder_count_right_a++;
}


unsigned long Motor::encoder_count_left_a;
//Getting left wheel speed.
static void EncoderCountLeftA()
{
  Motor::encoder_count_left_a++;
}
