// dwilson1.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <stdio.h>
#include <GL/glut.h>

float view_left = -0.5;
float view_right = 59.5;
float view_bottom = -0.5;
float view_top = 38.5;
GLsizei window_widthi, window_heighti;
GLfloat window_widthf, window_heightf;
float mouse_x = 0.0;
float mouse_y = 0.0;

FILE *stream = NULL;

#define N_ROOMS 10
#define N_DOORS 26

int motion[N_ROOMS];
int contact[N_ROOMS];
int pressure[N_ROOMS];
int doors[N_DOORS];

float motion_x1[N_ROOMS] = { 0.0, 4.0, 
				       4.0, 21.0, 36.0, 44.0,
				       4.0, 21.0, 36.0, 44.0 };
float motion_x2[N_ROOMS] = { 4.0, 59.0, 
				       21.0, 36.0, 44.0, 59.0,
				       21.0, 36.0, 44.0, 59.0 };
float motion_y1[N_ROOMS] = { 16.0, 16.0,
				       22.0, 22.0, 22.0, 22.0,
				       0.0, 0.0, 0.0, 0.0 };
float motion_y2[N_ROOMS] = { 22.0, 22.0,
				       38.0, 38.0, 38.0, 38.0,
				       16.0, 16.0, 16.0, 16.0 };

float motion_strength[N_ROOMS];

float motion_colors_r[N_ROOMS] = { 1.0, 0.0,
					     1.0, 0.0, 1.0, 0.0,
					     1.0, 0.5, 0.5, 1.0 };

float motion_colors_g[N_ROOMS] = { 0.5, 1.0,
					     0.0, 0.0, 1.0, 1.0,
					     0.0, 1.0, 0.5, 1.0 };

float motion_colors_b[N_ROOMS] = { 1.0, 1.0,
					     1.0, 1.0, 0.0, 0.0,
					     0.5, 0.5, 1.0, 0.5 };

float motion_border = 1.0;

float doors_x1[N_DOORS] = { 4.0, 3.0,
			    11.0, 12.5,
			    27.0, 28.5,
			    38.0, 39.5,
			    50.0, 51.5,
			    11.0, 12.5,
			    27.0, 28.5,
			    38.0, 39.5,
			    50.0, 51.5,
			    36.0, 35.0,
			    44.0, 43.0,
			    21.0, 20.0,
			    44.0, 43.0 };

float doors_x2[N_DOORS] = { 5.0, 4.0,
			    12.5, 14.0,
			    28.5, 30.0,
			    39.5, 41.0,
			    51.5, 53.0,
			    12.5, 14.0,
			    28.5, 30.0,
			    39.5, 41.0,
			    51.5, 53.0,
			    37.0, 36.0,
			    45.0, 44.0,
			    22.0, 21.0,
			    45.0, 44.0 };
			    
float doors_y1[N_DOORS] = { 17.5, 19.0,
			    22.0, 21.0,
			    22.0, 21.0,
			    22.0, 21.0,
			    22.0, 21.0,
			    16.0, 15.0,
			    16.0, 15.0,
			    16.0, 15.0,
			    16.0, 15.0,
			    28.0, 29.5,
			    28.0, 29.5,
			    7.0, 8.5,
			    7.0, 8.5 };

float doors_y2[N_DOORS] = { 19.0, 20.5,
			    23.0, 22.0,
			    23.0, 22.0,
			    23.0, 22.0,
			    23.0, 22.0,
			    17.0, 16.0,
			    17.0, 16.0,
			    17.0, 16.0,
			    17.0, 16.0,
			    29.5, 31.0,
			    29.5, 31.0,
			    8.5, 10.0,
			    8.5, 10.0 };

float doors_strength[N_DOORS];

float contact_x1[N_ROOMS] = { 1.0, 34.0, 
			      10.0, 26.0, 37.0, 49.0,
			      10.0, 26.0, 37.0, 49.0 };
float contact_x2[N_ROOMS] = { 2.0, 36.0, 
			      12.0, 28.0, 39.0, 51.0,
			      12.0, 28.0, 39.0, 51.0 };
float contact_y1[N_ROOMS] = { 17.0, 18.0,
				       29.0, 29.0, 29.0, 29.0,
				       7.0, 7.0, 7.0, 7.0 };
float contact_y2[N_ROOMS] = { 18.0, 20.0,
				       31.0, 31.0, 31.0, 31.0,
				       9.0, 9.0, 9.0, 9.0 };

float contact_strength[N_ROOMS];

float pressure_x1[N_ROOMS] = { 1.0, 37.0, 
			       13.0, 29.0, 40.0, 52.0,
			       13.0, 29.0, 40.0, 52.0 };
float pressure_x2[N_ROOMS] = { 2.0, 39.0, 
			      15.0, 31.0, 42.0, 54.0,
			       15.0, 31.0, 42.0, 54.0 };
float pressure_y1[N_ROOMS] = { 20.0, 18.0,
				       29.0, 29.0, 29.0, 29.0,
				       7.0, 7.0, 7.0, 7.0 };
float pressure_y2[N_ROOMS] = { 21.0, 20.0,
				       31.0, 31.0, 31.0, 31.0,
				       9.0, 9.0, 9.0, 9.0 };

float pressure_strength[N_ROOMS];

#define BACKGROUND_LIST 1

int counter = 0;

int no_more_input = 0;

void get_input( int *array, int index )
{
  array[index] = 0;
  if ( no_more_input )
    return;
  if ( fscanf( stream, "%d", &(array[index]) ) < 1 )
    {
      printf( "NO MORE INPUT\n" );
      no_more_input = 1;
      return;
    }
}

void display()
{
  int i;
  int j;

  counter++;

  if ( counter % 3 != 0 )
    return;

  for ( j = 0; j < N_ROOMS; j++ )
    {
      get_input( motion, j );
      if ( motion[j] )
	motion_strength[j] = 1.0;
    }
  for ( j = 0; j < N_ROOMS; j++ )
    {
      get_input( contact, j );
      if ( contact[j] )
	contact_strength[j] = 1.0;
    }
  for ( j = 0; j < N_ROOMS; j++ )
    {
      get_input( pressure, j );
      if ( pressure[j] )
	pressure_strength[j] = 1.0;
    }
  for ( j = 0; j < N_DOORS; j++ )
    {
      get_input( doors, j );
      if ( doors[j] )
	doors_strength[j] = 1.0;
    }

  glClear( GL_COLOR_BUFFER_BIT );

  glCallList( BACKGROUND_LIST );


  for ( i = 0; i < N_ROOMS; i++ )
    {
      if ( motion_strength[i] > 0.1 )
	{
	  glColor4f( 
		    motion_colors_r[i]*motion_strength[i], 
		    motion_colors_g[i]*motion_strength[i], 
		    motion_colors_b[i]*motion_strength[i], 
		    motion_strength[i] );
	  glRectf( motion_x1[i] + motion_border,
		   motion_y1[i] + motion_border,
		   motion_x2[i] - motion_border, 
		   motion_y2[i] - motion_border );
	}
      motion_strength[i] *= 0.98;
      if ( contact_strength[i] > 0.1 )
	{
	  glColor4f( 
		    contact_strength[i], 
		    contact_strength[i], 
		    contact_strength[i], 
		    contact_strength[i] );
	  glRectf( contact_x1[i], contact_y1[i],
		   contact_x2[i], contact_y2[i] );
	}
      contact_strength[i] *= 0.98;
      if ( pressure_strength[i] > 0.1 )
	{
	  glColor4f( 
		    pressure_strength[i], 
		    pressure_strength[i], 
		    pressure_strength[i], 
		    pressure_strength[i] );
	  glRectf( pressure_x1[i], pressure_y1[i],
		   pressure_x2[i], pressure_y2[i] );
	}
      pressure_strength[i] *= 0.98;
    }
  for ( i = 0; i < N_DOORS; i++ )
    {
      if ( doors_strength[i] > 0.1 )
	{
	  glColor4f( doors_strength[i], doors_strength[i], doors_strength[i],
		     doors_strength[i] );
	  glRectf( doors_x1[i], doors_y1[i],
		   doors_x2[i], doors_y2[i] );
	}
      doors_strength[i] *= 0.98;
    }

  /*
  glFlush();
  */
  glutSwapBuffers();
}

void init()
{
  int i;

  stream = fopen( "sensorlog1.txt", "r" );
  if ( stream == NULL )
    {
      fprintf( stderr, "Can't open data file.\n" );
      exit( -1 );
    }

  for ( i = 0; i < N_ROOMS; i++ )
    {
      motion_strength[i] = 0.0;
      contact_strength[i] = 0.0;
      pressure_strength[i] = 0.0;
    }
  for ( i = 0; i < N_DOORS; i++ )
    {
      doors_strength[i] = 0.0;
    }

  /*
  glClearColor( 1.0, 1.0, 1.0, 1.0 );
  */
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  gluOrtho2D( view_left, view_right, view_bottom, view_top );

  glNewList( BACKGROUND_LIST, GL_COMPILE_AND_EXECUTE );
  glPushAttrib( GL_CURRENT_BIT );
  for ( i = 0; i < N_ROOMS; i++ )
    {
      glColor4f( 
		motion_colors_r[i], motion_colors_g[i], motion_colors_b[i],
		1.0 );
      glRectf( motion_x1[i], motion_y1[i],
	       motion_x2[i], motion_y2[i] );
      glColor4f( 0.0, 0.0, 0.0, 1.0 );
      glRectf( motion_x1[i] + motion_border, motion_y1[i] + motion_border,
	       motion_x2[i] - motion_border, motion_y2[i] - motion_border );
    }
#ifdef COMMENT
  glColor4f( 1.0, 0.0, 0.0, 1.0 );
  glBegin( GL_POLYGON );
  glVertex2f( -0.5, -0.5 );
  glVertex2f( -0.5, 0.5 );
  glVertex2f( 0.5, 0.5 );
  glVertex2f( 0.5, -0.5 );
  glEnd();

  glRectf( 0.2, 0.9, -0.1, 0.1 );

  glRasterPos2f( -0.1, -0.1 );
  glutBitmapCharacter( GLUT_BITMAP_TIMES_ROMAN_10, 'a');
  glRasterPos2f( -0.2, -0.1 );
  glutBitmapCharacter( GLUT_BITMAP_8_BY_13, 'A');
  /* glutBitMapCharacter( GLUT_BITMAP_10_BY_20, 'a'); */
#endif
  glPopAttrib();
  glEndList();
}

void reshape( GLsizei w, GLsizei h )
{
  window_widthi = w;
  window_heighti = h;
  window_widthf = (GLfloat) w;
  window_heightf = (GLfloat) h;

  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  if ( w <= h )
    gluOrtho2D( view_left, view_right, 
		view_bottom*window_heightf/window_widthf,
		view_top*window_heightf/window_widthf );
  else
    gluOrtho2D( view_left*window_widthf/window_heightf, 
		view_right*window_widthf/window_heightf, 
		view_bottom, view_top );
  /* glMatrixMode( GL_MODELVIEW ); */
  glViewport( 0, 0, w, h );
}

void idle()
{
  glutPostRedisplay();
}

void convert_mouse_position( int x, int y, float *mx, float *my )
{
  
  mouse_x = (((float) x)/window_widthf)*(view_right - view_left) 
    + view_left;
  mouse_y = (((float) y)/window_heightf)*(view_bottom - view_top) 
    + view_top;
}

void keypress( unsigned char key, int x, int y )
{
  if ( key == 'q' || key == 'Q' || key == '\27' )
    exit( 0 );
  convert_mouse_position( x, y, &mouse_x, &mouse_y );
  printf( "You typed: %c, The mouse is at %d %d; %f %f\n", key, x, y,
	  mouse_x, mouse_y );
}

void mouse( int button, int state, int x, int y )
{
  char b, d;
  if ( button == GLUT_LEFT_BUTTON )
    b = 'L';
  else if ( button == GLUT_RIGHT_BUTTON )
    b = 'R';
  else
    b = 'M';
  if ( state == GLUT_UP )
    d = 'U';
  else
    d = 'D';
  convert_mouse_position( x, y, &mouse_x, &mouse_y );
  printf( "Mouse %c %c; %d %d; %f %f\n", b, d, x, y, mouse_x, mouse_y );
}

int main( int argc, char **argv )
{
  glutInit( &argc, argv );
  glutInitDisplayMode( GLUT_RGBA | GLUT_DOUBLE );
  glutInitWindowSize( 500, 500 );
  glutInitWindowPosition( 700, 300 );
  glutCreateWindow( "simple" );
  glutDisplayFunc( display );
  glutReshapeFunc( reshape );
  glutIdleFunc( idle );
  glutKeyboardFunc( keypress );
  glutMouseFunc( mouse );
  init();
  glutMainLoop();
	return 0;
}

