function createMaze(filename)

maze = imread(filename);

desired_ball_radius = 0.005; % meters
desired_hole_radius = 0.006; % meters
imshow(maze);

x_size = size(maze, 2); % x corresponds to columns
y_size = size(maze, 1); % y corresponds to rows
% real y coordinate will be y_size - y reported by ginput
% real x coordinate is simply the x reported by ginput
holes = [];
walls = [];

% Gather hole diameter information
title('Click to define hole diameter')
[x, y] = ginput(2);
actual_hole_diameter = sqrt((x(1)-x(2))^2 + (y(1)-y(2))^2);
actual_hole_radius = actual_hole_diameter/2;

% Gather hole position information
button = 1;
t = linspace(0, 2*pi, 50);
hole_number = 1;
while (button ~= 3)
    title('Click in the center of each hole.  Right click when done.');
    [x, y, button] = ginput(1);
    if (button ~= 3)
        x_circle = actual_hole_radius*cos(t) + x;
        y_circle = actual_hole_radius*sin(t) + y;
        hold on
        plot(x_circle, y_circle, 'r-');
        hold off
        holes(hole_number, :) = [x y_size-y];
        hole_number = hole_number + 1;
    end
end

% Gather wall position information
button = 1;
wall_number = 1;
while (button ~= 3)
    x_rect = [];
    y_rect = [];
    for i=1:2
        if (i == 1)
            title('Click the lower-left corner of a wall.  Right click when done with all walls.');
        else
            title('Click the upper-right corner of the wall.  Right click when done with all walls.');
        end
        [x, y, button] = ginput(1);    
        if (button == 3)
            break;
        else
            x_rect = [x_rect x];
            y_rect = [y_rect y];
        end
    end
    if (button ~= 3)
        hold on
        plot([x_rect(1) x_rect(1) x_rect(2) x_rect(2) x_rect(1)], [y_rect(1) y_rect(2) y_rect(2) y_rect(1) y_rect(1)], 'b-');
        walls(wall_number, :) = [x_rect(1) y_size-y_rect(1) x_rect(2) y_size-y_rect(2)];
        wall_number = wall_number + 1;
    end
    
end

% Gather start position information
title('Click at the starting location.')
[x_start, y_start] = ginput(1);
hold on
plot(x_start, y_start, 'gx');
y_start = y_size-y_start;

% Gather the goal information
title('Click the lower-left corner of the goal area.')
[x_goal y_goal] = ginput(1);
title('Click the upper-right corner of the goal area.')
[x_goal(2) y_goal(2)] = ginput(1);
hold on
plot([x_goal(1) x_goal(1) x_goal(2) x_goal(2) x_goal(1)], [y_goal(1) y_goal(2) y_goal(2) y_goal(1) y_goal(1)], 'y-');
y_goal = y_size-y_goal;
hold off

title('Creating maze file...')

% Scale all coordinates to match desired ball/hole size
scale_factor = desired_hole_radius/actual_hole_radius;
holes = holes*scale_factor;
walls = walls*scale_factor;
x_size = x_size*scale_factor;
y_size = y_size*scale_factor;
x_start = x_start*scale_factor;
y_start = y_start*scale_factor;
x_goal = x_goal*scale_factor;
y_goal = y_goal*scale_factor;

% open a file to write the board info into
fid = fopen([filename(1:end-4) '.txt'], 'w');

% print the board size info line
fprintf(fid, 'board r 0.0 0.0 %0.3f %0.3f\n', x_size, y_size);

% print the start info line
fprintf(fid, 'start %0.3f %0.3f\n', x_start, y_start);

% print the goal info line
fprintf(fid, 'goal r %0.3f %0.3f %0.3f %0.3f\n', x_goal(1), y_goal(1), x_goal(2), y_goal(2));

% write the wall information
for i=1:wall_number-1
    fprintf(fid, 'wall r %0.3f %0.3f %0.3f %0.3f\n', walls(i,:));
end

% write the hole information
for i=1:hole_number-1
    fprintf(fid, 'hole c %0.3f %0.3f 0.006\n', holes(i,:));
end

title('Creating maze file...done.')
fclose(fid);