/************************************************************************/
/* DEFINES */

#define TRUE 1
#define FALSE 0

/* State indices */
#define XX 0
#define YY 1
#define XD 2
#define YD 3

/* Rectangle indices */
#define LEFT 0
#define BOTTOM 1
#define RIGHT 2
#define TOP 3
#define X1 LEFT
#define Y1 BOTTOM
#define X2 RIGHT
#define Y2 TOP

/* hole indices: XX, YY, RADIUS */
#define RADIUS 2 /* index of hole radius */

#define N_STATES 4
#define N_ACTIONS 2
#define MAX_N_OBSTACLES 100
#define MAX_N_HOLES 100

/* Status flags for positions */
#define GOAL 1
#define OBSTACLE 2
#define HOLE 3

/* Shape types */
#define NO_SHAPE 0
#define RECTANGLE 1
#define CIRCLE 2
#define TRIANGLE 3

/* Constraint states */
#define FREE 1
#define N 10
#define E 11
#define S 12
#define W 13
#define NE 20
#define SE 21
#define SW 22
#define NW 23

/* Resolution of collision detection maps */
#define MAP_RESOLUTION 200


/************************************************************************/
/* TYPEDEFS */

typedef struct shape
{
  int type;
  float p[4]; /* parameters */
} SHAPE;

typedef struct shape_ref
{
  SHAPE *s;
  struct shape_ref *next;
} SHAPE_REF;

typedef struct xboardx
{
  char *name;

  /* Simulation Parameters */
  float coefficient_of_restitution;
  float plastic_impact_velocity_threshold;
  float puck_radius;
  float drag; /* Velocity loss in 1 second, very approximate */
  float max_force;
  float random_force_0;

  /* state */
  float puck[N_STATES];
  float global_time;

  /* control */
  float force[N_ACTIONS];

  /* board description */
  SHAPE board;
  float start[N_STATES];
  SHAPE goal;
  int n_obstacles;
  SHAPE obstacles[MAX_N_OBSTACLES];
  int n_holes;
  SHAPE holes[MAX_N_HOLES];

  /* collision detection stuff */
  SHAPE_REF *obstacle_map[MAP_RESOLUTION][MAP_RESOLUTION];
  SHAPE_REF *hole_map[MAP_RESOLUTION][MAP_RESOLUTION];

  /* constraint management stuff */
  int constraint_state;
  SHAPE *constraint1;
  SHAPE *constraint2;

} BOARD;

/************************************************************************/

int in_obstacle( BOARD *b, float *state );
int in_hole( BOARD *b, float *state );
int in_goal( BOARD *b, float *state );
float do_simulation( BOARD *b, float dt ); /* OLDER interface, do not use. */
BOARD *create_board();
/* The following three functions are the interface I would like you to use. */
int initialize_maze( char *board_file, BOARD *b );
int set_state( BOARD *b, float *state, int *status );
int apply_action( BOARD *b, float *u, float time_step, float *next_state,
		  int *status );

/************************************************************************/
