#include <cthreads.h>
#include <mach/clock_types.h>
#include <mach/clock.h>

#include "jiffies.h"

void* jiffies_thread ( void *arg );

mach_port_t rt_clock;
tvalspec_t cur_time;
unsigned long jiffy_count = 0;
mutex_t jiffy_mutex;

#define HZ 60
#define JIFFIES_BUNCH 1
#define NSEC_JIFFIES ((NSEC_PER_SEC / HZ) * JIFFIES_BUNCH)

void jiffies_init ( void ) { 
  kern_return_t kr;
  kr = host_get_clock_service ( host_port,
				REALTIME_CLOCK,
				&rt_clock );
  if ( kr != KERN_SUCCESS ) 
    panic("Can't get realtime clock");

  jiffy_mutex = mutex_alloc();

  kr = clock_get_time(rt_clock, &cur_time );
  if ( kr != KERN_SUCCESS ) 
    panic("can't get real time");

  cthread_detach( cthread_fork(jiffies_thread, (void*)NULL) );
  jiffy_count = 0;
}

unsigned long jiffies_count ( void ) { 
  unsigned long t = 0;
  mutex_lock(jiffy_mutex);
  t = jiffy_count;
  mutex_unlock(jiffy_mutex);
  return t;
}

tvalspec_t jiffies_curtime ( void ) { 
  kern_return_t kr;
  tvalspec_t ntime;

  kr = clock_get_time ( rt_clock,
			&ntime );
  if ( kr != KERN_SUCCESS ) panic("can't get real time");
  return ntime;
}

void* jiffies_thread ( void *arg ) { 
  kern_return_t kr;
  tvalspec_t sleep_time;
 
  cthread_set_name(cthread_self(), "Jiffies thread");
  
  kr = clock_get_time(rt_clock, &cur_time );

  if ( kr != KERN_SUCCESS ) 
    panic("Jiffies thread can't get clock time");

  while(1) { 
    if ( cur_time.tv_nsec >= NSEC_PER_SEC - NSEC_JIFFIES ) {
	sleep_time.tv_nsec = cur_time.tv_nsec - (NSEC_PER_SEC - NSEC_JIFFIES);
	sleep_time.tv_sec = cur_time.tv_sec +1;
    } else { 
	sleep_time.tv_nsec = cur_time.tv_nsec + NSEC_JIFFIES;
	sleep_time.tv_sec = cur_time.tv_sec;
    }
 
    kr = clock_sleep(rt_clock, TIME_ABSOLUTE, sleep_time, &cur_time );

    mutex_lock(jiffy_mutex);
    jiffy_count++;
    mutex_unlock(jiffy_mutex);

    if ( kr != KERN_SUCCESS ) { 

    }
  }
}

