/*
 * smail.c -- directs incoming email to agents
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <kapi.h>
#include <kapi_int.h>
#include <kaTCP.h>

#define HOSTNAME "localhost"

main(argc, argv)
     int argc;
     char *argv[];
{
  int fd, port, TCPid;
  ParsedURL *anspurl = NULL, *purl = NULL;
  TCPInfo *info = NULL;
  char buffer[K_MAX_MESSAGE_SIZE];

  char *aname = NULL;
  char ANSurl[MAXURLLENGTH];
  char agentname[MAXNAMESIZE];
  char host[MAXNAMESIZE];
  char line[1024];

  bzero(buffer, K_MAX_MESSAGE_SIZE);
  bzero(ANSurl, MAXURLLENGTH);
  bzero(agentname, MAXNAMESIZE);
  bzero(host, MAXNAMESIZE);
  bzero(line, 1024);

  if (argc > 1)
    sprintf(ANSurl, "%s", argv[1]);
  else
    sprintf(ANSurl, "%s", HOSTNAME);

  if ((anspurl = ParseURL(ANSurl)) == NULL) {
    fprintf(stderr, "ANS URL is invalid.\n");
    return 1;
  };

  while (gets(line) && *line)
    if ((strncasecmp(line, "subject: ", 9) == 0) &&
	(aname = strtok(line+9, " ")))
      strcpy(agentname, aname);

  /* Connect to ANS to find URLs for agentname */
  purl = ANSLookup(agentname, anspurl);

  if ((TCPid = TransportID("tcp")) == 0) {
    fprintf(stderr, "Can't use smail w/o tcp support\n");
    return 1;
  }

  while (purl && purl->transtype != TCPid)
    purl = purl->alternate;

  if (purl == NULL) {
    fprintf(stderr, 
	    "Could not locate a TCP connection to the agent: %s.\n", 
	    agentname);
    return 2;
  }

  info = (TCPInfo *) purl->transinfo;
  strcpy(host, info->host);
  port = info->port;

  if ((fd=TCPconnect(host, port)) == -1) {
    fprintf(stderr, "Trying to connect to host: %s on port:%d\n", host, port);
    return 3;
  }

  strcpy(buffer, "");
  while (fgets(line, 1024, stdin) && *line) {
    if (line[0] != '\n')
      strcat(buffer, line);
  }
  TCPsend(buffer, fd);

  close(fd);
  return 0;
}
