#ifdef DO_MBUS_TRANS

/*
 * kasexp.h -- MBUS related KQML API parsing routines
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef KASEXP_H
#define KASEXP_H

#include <api.h>

#if defined(__STDC__) || defined(__cplusplus) 
#define P(s) s
#else
#define P(s) ()
#endif

#if defined(__cplusplus)
extern "C" {
#endif

/*
 * do typedefs if api.h in mbus isn't being included
 * #ifndef MB_PATCH_H test needs to be added to mbus/lib/api.h
 */

#ifndef MB_API_H
#define MB_PATCH_H
typedef struct mbobject * t_sexp;
#endif /* MB_API_H */

/* Used to extract keys from kqml message bodies */
struct keytable {
  char *name;
  char *value;
};

extern char *KSexpToString P((t_sexp sexp, char* string));
extern t_sexp KStringToSexp P((char* string));
extern t_sexp KGetKeySexp P((t_sexp sexp, char* key));
extern t_sexp KCar P((t_sexp sexp));
extern void KFreeString P((char* str));
extern void KFreeSexp P((t_sexp sexp));
extern char* KGetKeyString P((t_sexp sexp, char* key, char* result));
extern char* KGetKeyValue P((char *kqmlstr, int keyc, struct keytable *keyv));
extern int KGetKeys P((char *kqmlstr, int keyc, struct keytable *keyv));

#if defined(__cplusplus)
} /* extern "C" */
#endif

#endif
#endif
