#ifdef DO_MBUS_TRANS
/*
 * kasexp.c -- MBUS related KQML API parsing routines
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <kapi.h>
#include <kapi_int.h>
#include <keyword.h>
#include <kasexp.h>

extern int MBLogLevel;

char *qwd2qch();   

char *
#if defined(__STDC__) || defined(__cplusplus)
KSexpToString(t_sexp sexp, char* string)
#else
KSexpToString(sexp, string)
	t_sexp  sexp;
	char    *string;
#endif
{
	char  *s;

	s = MBprint_Cstring(sexp);
#ifdef PREPROCESSQUOTE
	strcpy(string, qwd2qch(s));
#else
	strcpy(string, s);
#endif
	
	/*	(*MBfree_func)(s); */
	free(s);

	return string;
}

t_sexp
#if defined(__STDC__) || defined(__cplusplus)
KStringToSexp(char* str)
#else
KStringToSexp(str)
   char* str;
#endif
{
   return MBparse_Cstring(str);
}

t_sexp
#if defined(__STDC__) || defined(__cplusplus)
KGetKeySexp(t_sexp sexp, char* key)
#else
KGetKeySexp(sexp, key)
   t_sexp sexp;
   char * key;
#endif
{
   struct keyword_entry_struct keytable[1];
   keytable[0].keyword = key;
   keytable[0].value = NULL;
   keytable[0].type = KEYWORD_GET_SEXP;

   MBparse_keywords(MBcdr(sexp), keytable, 
	                 sizeof(keytable)/sizeof(struct keyword_entry_struct));

   return( (t_sexp)keytable[0].result );
}

t_sexp
#if defined(__STDC__) || defined(__cplusplus)
KCar(t_sexp sexp)
#else
KCar(sexp)
	t_sexp   sexp;
#endif
{
	return MBcar(sexp);
}

t_sexp
#if defined(__STDC__) || defined(__cplusplus)
KCdr(t_sexp sexp)
#else
KCdr(sexp)
	t_sexp   sexp;
#endif
{
	return MBcdr(sexp);
}

void
#if defined(__STDC__) || defined(__cplusplus)
KFreeString(char* str)
#else
KFreeString(str)
   char* str;
#endif
{
   free(str);
   return;
}

void
#if defined(__STDC__) || defined(__cplusplus)
KFreeSexp(t_sexp sexp)
#else
KFreeSexp(sexp)
   t_sexp sexp;
#endif
{
   MBfree(sexp);
   return;
}


char*
#if defined(__STDC__) || defined(__cplusplus)
KGetKeyString(t_sexp sexp, char* key, char* result)
#else
KGetKeyString(sexp, key, result)
   t_sexp sexp;
   char* key;
   char* result;
#endif
{
   t_sexp s = KGetKeySexp(sexp,key);

   if (s == NULL)
      return NULL;
   KSexpToString(s, result);
   
   return result;
}

char *
#if defined(__STDC__) || defined(__cplusplus)
qwd2qch(char *message)
#else
qwd2qch(message)
  char *message;
#endif
  {
    	static char buf2[K_MAX_MESSAGE_SIZE];
        int paren=0,quote=0,bs=0,iqparen=0,inquote=0;
        int ppending=0,wsp=0;
        char *foo=buf2;

#define CANDG  {*foo++ = *message;continue;}
#define NORMAL(c) ((c!=' ')&&(c!='(')&&(c!='"'))&&(c!=')')
        *foo='\0';
        do
        {
          if(ppending){
            if(*message==' ') {wsp++; continue;}
            if((*message!='q')||(strncasecmp(message,"quote",5)))
            {
              *foo++='(';
              ppending=0;
              while(wsp--) *foo++=' ';
              wsp=0;
            }
            else
            {
              ppending=wsp=0;
              inquote=1;
              iqparen=paren-1;
              message+=5;
              while((*message==' ')&&(*message))
                message++;
              *foo++='\'';
            }
	  }
          if(*message=='\\') {bs^=1;CANDG}
          if(bs) CANDG
          if(*message=='"') {quote^=1;CANDG}
          if(quote) CANDG
          if(*message=='(') {paren++;ppending=1;continue;}
          else if(*message==')') {
            paren--;
            if((inquote)&&(iqparen==paren)) continue;
          }

          CANDG;
        } while (*++message);          
        *foo='\0';
        return(buf2);
  }

char*
#if defined(__STDC__) || defined(__cplusplus)
KGetKeyValue(char *kqmlstr, int keyc, struct keytable *keyv)
#else
KGetKeyValue(kqmlstr, keyc, keyv)
  char *kqmlstr;
  int keyc;
  struct keytable *keyv;
#endif
{
  char buf[K_MAX_MESSAGE_SIZE], 
       keyname[80], 
       keyvalue[K_MAX_MESSAGE_SIZE], 
       *p, *q;
  int i, nesting;

  keyname[0] = keyvalue[0] = '\0';

  strcpy(buf, kqmlstr);  /* to avoid clobbering something important */

  p = buf;

  while (p && strcmp(p, "")) {
    if (*p != ':') {
      while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r') p++; /* skip over token */
      while (p && (*p == ' ' || *p == '\n' || *p == '\t' || *p == '\r')) p++; /* skip over whitespace */
      continue;
    }

    /* Extract keyname */

    p++; /* Skip colon */
    q = p;
    while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r') p++;
    strncpy(keyname, q, p-q);

    while (p && (*p == ' ' || *p == '\n' || *p == '\t' || *p == '\r')) p++; /* skip over whitespace */

    /* Extract value */
    nesting = 0;
    q = p;

    do {

      /* What happens when a string has nested parenthesis.  Can't just ignore
	 whitespace. */

      if (nesting == 0)
	while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r' &&
	       *p != '(' && *p != ')') p++;
      else if (nesting > 0)
	while (p && *p != '(' && *p != ')') p++;

      if (*p == '(') {
	nesting++;
	p++;
      }
      else if (*p == ')') {
	nesting--;
	p++;
      }

    } while (nesting > 0);
    
    if (nesting == 0)
      strncpy(keyvalue, q, p-q);
    else if (nesting == -1)
      strncpy(keyvalue, q, p-q-1);

    for (i=0; i<keyc; i++)
      if (strcasecmp(keyv[i].name, keyname) == 0) {
        strcpy(keyv[i].value, keyvalue);
	return keyv[i].value;
      };

    keyname[0] = keyvalue[0] = '\0';
  }

  return 0;
}

/* Return the number of key-values found */
int
#if defined(__STDC__) || defined(__cplusplus)
KGetKeys_Values(char *kqmlstr, int keyc, struct keytable *keyv)
#else
KGetKeys_Values(kqmlstr, keyc, keyv)
  char *kqmlstr;
  int keyc; /* Maximum number of keys */
  struct keytable *keyv;
#endif
{
  char buf[K_MAX_MESSAGE_SIZE], keyname[80], keyvalue[256], *p, *q;
  int i, nesting;

  buf[0] = keyname[0] = keyvalue[0] = '\0';

  strcpy(buf, kqmlstr);  /* to avoid clobbering something important */

  p = buf;
  i = 0;

  while (p && strcmp(p, "") && i < keyc) {
    if (*p != ':') {
      while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r') p++; /* skip over token */
      while (p && (*p == ' ' || *p == '\n' || *p == '\t' || *p == '\r')) p++; /* skip over whitespace */
      continue;
    }

    /* Extract keyname */

    p++; /* Skip colon */
    q = p;
    while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r') p++;
    strncpy(keyname, q, p-q);

    while (p && (*p == ' ' || *p == '\n' || *p == '\t' || *p == '\r')) p++; /* skip over whitespace */

    /* Extract value */
    nesting = 0;
    q = p;

    do {

      /* What happens when a string has nested parenthesis.  Can't just ignore
	 whitespace. */

      if (nesting == 0)
	while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r' &&
	       *p != '(' && *p != ')') p++;
      else if (nesting > 0)
	while (p && *p != '(' && *p != ')') p++;

      if (*p == '(') {
	nesting++;
	p++;
      }
      else if (*p == ')') {
	nesting--;
	p++;
      }

    } while (nesting > 0);
    
    if (nesting == 0)
      strncpy(keyvalue, q, p-q);
    else if (nesting == -1)
      strncpy(keyvalue, q, p-q-1);

    strcpy(keyv[i].name, keyname);
    strcpy(keyv[i].value, keyvalue);

    keyname[0] = keyvalue[0] = '\0';

    i++;
  }

  return i;
}

/* Return the number of keys found */
int
#if defined(__STDC__) || defined(__cplusplus)
KGetKeys(char *kqmlstr, int keyc, struct keytable *keyv)
#else
KGetKeys(kqmlstr, keyc, keyv)
  char *kqmlstr;
  int keyc; /* Maximum number of keys */
  struct keytable *keyv;
#endif
{
  char buf[K_MAX_MESSAGE_SIZE], keyname[80], keyvalue[K_MAX_MESSAGE_SIZE], *p, *q;
  int i, nesting;

  buf[0] = keyname[0] = keyvalue[0] = '\0';

  strcpy(buf, kqmlstr);  /* to avoid clobbering something important */

  p = buf;
  i = 0;

  while (p && strcmp(p, "") && i < keyc) {
    if (*p != ':') {
      while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r') p++; /* skip over token */
      while (p && (*p == ' ' || *p == '\n' || *p == '\t' || *p == '\r')) p++; /* skip over whitespace */
      continue;
    }

    /* Extract keyname */

    p++; /* Skip colon */
    q = p;
    while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r') p++;
    strncpy(keyname, q, p-q);

    while (p && (*p == ' ' || *p == '\n' || *p == '\t' || *p == '\r')) p++; /* skip over whitespace */

    /* Extract value */
    nesting = 0;
    q = p;

    do {

      /* What happens when a string has nested parenthesis.  Can't just ignore
	 whitespace. */

      if (nesting == 0)
	while (p && *p != ' ' && *p != '\n' && *p != '\t' && *p != '\r' &&
	       *p != '(' && *p != ')') p++;
      else if (nesting > 0)
	while (p && *p != '(' && *p != ')') p++;

      if (*p == '(') {
	nesting++;
	p++;
      }
      else if (*p == ')') {
	nesting--;
	p++;
      }

    } while (nesting > 0);
    
    if (nesting == 0)
      strncpy(keyvalue, q, p-q);
    else if (nesting == -1)
      strncpy(keyvalue, q, p-q-1);

    strcpy(keyv[i].name, keyname);

    keyname[0] = '\0';

    i++;
  }

  return i;
}
#endif
