#ifndef KAPI_INT_H
#define KAPI_INT_H
   
/*
 * kapi_int.h -- include file for KQML API
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * 11 Jan 94 wtwong@eit.com created kapi internal implementation include file
 */


#undef _ANSI_ARGS_
#undef CONST
#if ((defined(__STDC__) || defined(SABER)) && !defined(NO_PROTOTYPE)) || defined(__cplusplus)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)	x
#   define CONST const
#   ifdef __cplusplus
#       define VARARGS (...)
#   else
#       define VARARGS ()
#   endif
#else
#   define _ANSI_ARGS_(x)	()
#   define CONST
#endif

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <kapi.h>
#include <kaHash.h>
#include <kaDebug.h>

#define WHITESPACE      " \t\n\r"
#define MSG_EOF         '\004'

#define MAXFDLENGTH     4        /* Maximum number of digits in fd    */
#define MAXNAMESIZE     128      /* Longest agent name                */
#define MAXURLLENGTH    128      /* Longest URL                       */
#define MAXANSURLS      20       /* Most number of URLs stored at ANS */
#define MAXHTTPLINELEN  80       /* Longest HTTP line                 */
#define LOCALNAME       "_THIS_" /* Internal hash name of this agent. */

/* * * * * * * * * * * * * * * * */
/*     Parsed URL Structure      */
/* * * * * * * * * * * * * * * * */

#define OPEN_CON         1
#define CLOSED_CON       2
#define LISTENING_CON    3
#define CONNECTIONLESS   4
#define CONNECTION_ERROR 5
#define SHARED_CON       6

struct parsedurl {
  char name[MAXNAMESIZE];
  char url[MAXURLLENGTH];
  int  transtype;
  /* State of connection. Possible values include OPEN_CON, CLOSED_CON, 
     LISTENING_CON, CONNECTIONLESS, CONNECTION_ERROR, SHARED_CON */
  int state;     
  int fd;
  struct parsedurl *alternate;
  void *transinfo;
  int  hashed;
};

#if 0
typedef struct parsedurl ParsedURL;
#endif

/* * * * * * * * * * * * * * * * */
/* Parsed KQML Message Structure */
/* * * * * * * * * * * * * * * * */

typedef struct ParsedKQMLMess {
  char *performative;
  char *sender;
  char *receiver;
  KeyList *other_pairs;
} ParsedKQMLMess;


/* * * * * * * * * * * * * * * * */
/* Transport Entry Structure     */
/* * * * * * * * * * * * * * * * */

typedef struct TransportEntry {
  char name[MAXNAMESIZE];
  ParsedURL *(*ParseURL) _ANSI_ARGS_((char *, int));
  int (*Listen) _ANSI_ARGS_((ParsedURL *));
  ParsedURL *(*Connect) _ANSI_ARGS_((ParsedURL *, int));
  int (*Disconnect) _ANSI_ARGS_((ParsedURL *));
  char *(*Get) _ANSI_ARGS_((ParsedURL *, char *));
  int (*Send) _ANSI_ARGS_((ParsedURL *, char *));
} TransportEntry;

/* * * * * * * * * * * * * * * * */
/* Shared Global Variables       */
/* * * * * * * * * * * * * * * * */

ParsedURL *gANSpurl;                /* the locator for the name server */
HashTable OpenConns;                /* Table to cache open connections */


/* * * * * * * * * * * * * * * * * * * * */
/* Functions for implementation of kapi  */
/* * * * * * * * * * * * * * * * * * * * */

#if defined(__cplusplus)
extern "C" {
#endif

extern ParsedURL* gANSpurl;
extern HashTable  OpenConns;
extern TransportEntry* Transports[];

extern void DeletePurl _ANSI_ARGS_((ParsedURL *purl));
extern void DeletePMessage _ANSI_ARGS_((ParsedKQMLMess *mess));
extern char* ParsedMessToString _ANSI_ARGS_((ParsedKQMLMess *, char *));
extern ParsedURL* ParseURL _ANSI_ARGS_((char *));
extern ParsedURL* ANSLookup _ANSI_ARGS_((char *, ParsedURL *));
extern ParsedURL* getReceiverURL _ANSI_ARGS_((char *));
extern char* kqml2mime _ANSI_ARGS_((char *));
extern char* mime2kqml _ANSI_ARGS_((char *));
extern int TransportID _ANSI_ARGS_((char *));
extern int flushPurlCache _ANSI_ARGS_((HashTable*));
extern int deletePurlCacheEntry _ANSI_ARGS_((char*, HashTable*));
extern int deletePurlCacheEntryURL _ANSI_ARGS_((char*, char*, HashTable*));
extern int deletePurlCacheEnriesURL _ANSI_ARGS_((char*, HashTable*));
extern int deleteURLFromEntry _ANSI_ARGS_((char*, HashEntry*));
extern ParsedURL* insertConnectionTable _ANSI_ARGS_((char*, ParsedURL*));
extern char* canonicalName _ANSI_ARGS_((char*));

#if defined(__cplusplus)
} /* extern "C" */
#endif

#endif /* KAPI_INT_H */
