/*
 * kapi.h -- include file for KQML API
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * October 3 1994  rjohnson@aic.lockheed.com, harada@aic.lockheed.com - new
 *                 convenience functions added; return/error codes changed.
 * Mon Jul 18 1994 olsen@cs.stanford.edu performed a substantial rewrite of
 *                 much of the code, to improve extendability and to allow
 *                 persistent connections to remain open.
 * 22 May 94 olsen@cs.stanford.edu several changes & bug fixes
 * 28 Jan 94 wtwong@eit.com added ANS interaction functions
 * 11 Jan 94 wtwong@eit.com extracted implementation details from kapi.h
 * 9 Nov 93 wtwong@eit.com abstracted KAPI functions from MBUS transport
 * 5 Oct 93 weber@eit.com modularized transports
 * 20-Jul-93  ekr@eitech.com added lame wrappers to fix KQML ' bug
 * Mon Apr  5 1993 salil@custom.customware.com minor fixes using tmptr in
 *                 GetSexp calls
 * Thu Mar 18 1993 salil@eitech.com added to distribution
 * Thu Mar 18 1993 salil@eitech.com  __STDC__ and __cplusplus
 * Thu Mar 18 1993 salil@eitech.com fixed memory leak in KGetSexp
 *  and KGetSexp_or_Wait
 * Thu Mar 18 1993 salil@eitech.com cleaned up
 * Thu Mar 25 1993 pfung@sunrise.Stanford.EDU Better way of fixing mem leak
 *
 */


   
#ifndef K_API_H
#define K_API_H
   
#if defined(__STDC__) || defined(__cplusplus) 
#define P(s) s
#else
#define P(s) ()
#endif

#if defined(__cplusplus)
extern "C" {
#endif

#include <stdio.h>
#include <string.h>

#define K_MAX_MESSAGE_SIZE 16384

/*
 * Error codes
 */
#define K_OK                      0    /* Success                      */

#define K_BAD_KQML                1    /* Unable to parse KQML message */
#define K_NO_ANS_RESPONSE         2    /* Unable to connect to ANS     */
#define K_BAD_URL                 3    /* Illegal URL                  */
#define K_NO_SENDER               4    /* KQML message has no sender   */
#define K_NO_RECEIVER             5    /* KQML message has no receiver */
#define K_NO_TRANSPORT            6    /* No transport for agent       */
#define K_NO_MSG                  7    /* No message on connections    */
#define K_NO_FIELD                8    /* KQML message without field   */
#define K_NO_ACTIVE_URL           9    /* No active URL connection     */

#define K_ERROR                  -1    /* Other errors                 */

/*
 * The URL (Uniform Resource Locator) types are as follows:
 *
 * For Service Mail: smail://host/username/service
 * For MBUS: mbus://host:portnumber
 * For TCP: tcp://host:portnumber
 * For HTTP: http://host:portnumber
 */

/**********************************************************************
 * Looking up transport protocols for a given agent
 **********************************************************************
 * The arguments are: ANS URL, agent name, return value buffer
 * Returns: KQML message listing all the URLs.
 */
extern int KLookup P((char *, char *, char *));
extern int KSetDefaultANS P((char *url));
extern int KInit P(());
extern int KSetUp P((char *, char *, int));  /* KSetUp(agentname,ANS url, lookup flag) */
extern int KDisconnect P(());             /* KDisconnect() */
extern int KListen P((char *url));
extern int KCacheURL P((char *agent, char *url));
extern int KUnCacheURL P((char *agent, char *url));
extern int KGetOpenFd P((int));

/**********************************************************************
 * Registering and unregistering transport protocol capabilities
 **********************************************************************
 * The arguments are: ANS URL, agent name, agent transport URL
 */
extern int KRegister P((char *, char *, char *));
extern int KUnRegister P((char *, char *, char *));



/**********************************************************************
 * Sending Messages over a transport protocol
 **********************************************************************/
extern int KSendString P((char *));     
/* KSendString(message) */


/**********************************************************************
 * Receiving messages over transport protocol
 **********************************************************************/

/*  non-blocking read
int
KGetString(str)
	char  *str;     a buffer for the string received */
extern int KGetString P((char *));

/* blocking read
int
KGetString_or_Wait(str)
	char  *str;     a buffer for the string received */
extern int KGetString_or_Wait P((char *));

/* peek to see a message is ready to be read
int 
KPeek() */
extern int KPeek P(());


/**********************************************************************
 * Parsing Functions 
 **********************************************************************/

typedef struct {
  char *keyword; /* Keyword String */
  char **value_address; /* Target address for value 
			   associated with key */
} KeydPair;

struct keylist { 
  char *keyword;
  char *value;
  struct keylist *prev;
};

/* Linked list of keyword-value pairs */
typedef struct keylist KeyList; 
typedef struct parsedurl ParsedURL; 

/* Function Prototypes */
extern void deleteKeyList P((KeyList *));

extern int KParse P((char *, char **, 
		     KeydPair *, KeyList **));

extern int KGetField P((char*, char*, char**, long));
extern int KSetField P((char*, char*, char*, char**, long));

struct address {
  char name[100];
  char password[100];
  char host[100];
char port[10];
char message_method[100];
char email[100];
char kqml_extensions[100];
};

typedef struct address Address;

extern int KRouterRegister P((Address*, char*));
extern int KRouterRegisterWithString P((char*, char*));
extern int KRouterConnect P ((Address*, char*));
extern int KRouterConnectWithString P ((char* addr_str, char *routername));
extern int KSendStringToAMR P((char* ,char* ));
extern int KGetRouterString_or_Wait P ((char* str,char* routername));
extern char* getRouterMail P((ParsedURL *purl));
extern int KDisconnectRouter P((char* ,char*));
extern int KSendDeleteMessageToAMR P((char*,char* ));
extern int KUnregisterRouterWithString P((char*, char*));
extern int KUnregisterRouter P((Address*, char*));

#if defined(__cplusplus)
} /* extern "C" */
#endif

#endif /* K_API_H */


