/*
 * kaTransports.c -- KQML API get routines
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <kapi_int.h>

/* * * * * * * * * * * * * * * * */
/* Transport Entry Structure     */
/* * * * * * * * * * * * * * * * */
/*     Defined in kapi_int.h
typedef struct TransportEntry {
  char name[MAXNAMESIZE];
  ParsedURL *(*ParseURL) _ANSI_ARGS_((char *, int));
  int (*Listen) _ANSI_ARGS_((ParsedURL *));
  ParsedURL *(*Connect) _ANSI_ARGS_((ParsedURL *, int));
  int (*Disconnect) _ANSI_ARGS_((ParsedURL *));
  char *(*Get) _ANSI_ARGS_((ParsedURL *, char *));
  int (*Send) _ANSI_ARGS_((ParsedURL *, char *));
} TransportEntry;
*/

/* Set up for different transports */

#ifdef DO_SMAIL_TRANS
#include <kaSMAIL.h>
TransportEntry smailEntry = {
  "smail", smailParseURL, smailListen, smailConnect, smailDisconnect, 
  smailGet, smailSend
};
#endif

#ifdef DO_MBUS_TRANS
#include <kaMBUS.h>
TransportEntry mbusEntry = {
  "mbus", mbusParseURL, mbusListen, mbusConnect, mbusDisconnect, mbusGet, 
  mbusSend
};
#endif

#ifdef DO_TCP_TRANS
#include <kaTCP.h>
TransportEntry tcpEntry = {
  "tcp", tcpParseURL, tcpListen, tcpConnect, tcpDisconnect, tcpGet, tcpSend
};
#endif

#ifdef DO_HTTP_TRANS
#include <kaHTTP.h>
TransportEntry httpEntry = {
  "http", httpParseURL, httpListen, httpConnect, httpDisconnect, httpGet, 
  httpSend
};
#endif

TransportEntry unknownEntry = {
  "unknown", NULL, NULL, NULL, NULL, NULL, NULL
};

/* * * * * * * * * * * * * * * * * * * * * * * */
/*           Global Transports Array           */
/* * * * * * * * * * * * * * * * * * * * * * * */
TransportEntry *Transports[] = {
  &unknownEntry,

#ifdef DO_SMAIL_TRANS
  &smailEntry,
#endif

#ifdef DO_MBUS_TRANS
  &mbusEntry,
#endif

#ifdef DO_TCP_TRANS
  &tcpEntry,
#endif

#ifdef DO_HTTP_TRANS
  &httpEntry,
#endif
  NULL
};

/*
 *----------------------------------------------------------------------
 *
 * TransportID --
 *
 *	Finds the integer type corresponding to given string
 *
 * Results:
 *	int if successful
 *      0 for failure
 *
 * Side effects:
 *
 *
 *----------------------------------------------------------------------
 */

int
#if defined(__STDC__) || defined(__cplusplus)
TransportID(char *name) 
#else
TransportID(name)
     char *name;
#endif
{
  int i = 1;
  TransportEntry *Entry = Transports[1];
  
  while(Entry != NULL) {
    if (strcasecmp(name,Entry->name) == 0)
      return(i);
    Entry = Transports[++i];
  }
  return(0);
}
    

