/*
 * kaSMAIL.c -- KQML API SMAIL transport specific routines
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifdef DO_SMAIL_TRANS

#include <kapi_int.h>
#include <kaSMAIL.h>

/*
 *----------------------------------------------------------------------
 *
 * smailParseURL --
 *
 *	Parses URLs beginning with 'smail://'
 *
 * Results:
 *	ParsedURL if successful
 *      NULL for failure
 *
 * Side effects:
 *      none
 *
 *----------------------------------------------------------------------
 */

ParsedURL *
#if defined(__STDC__) || defined(__cplusplus)
smailParseURL(char *urlstring, int ttype)
#else
smailParseURL(urlstring, ttype)
     char *urlstring;
     int ttype;
#endif
{
  ParsedURL *purl;
  SMAILInfo *info;
  char tmpbuffer[MAXURLLENGTH], *t = NULL;

  tmpbuffer[0] = '\0';

  if (urlstring == NULL || strncasecmp(urlstring,"smail://", 8))
    return(NULL);
  strcpy(tmpbuffer, &urlstring[8]); /* Skip "smail://" part */

  if ((t=strtok(tmpbuffer, "/")) == NULL) 
    return NULL;

  purl = (ParsedURL *) calloc(1,sizeof(ParsedURL));
  info = (SMAILInfo *) calloc(1,sizeof(SMAILInfo));
  strcpy(info->host, t);

  if ((t=strtok(NULL, "/")) == NULL) {
    free(purl);
    free(info);
    return NULL;
  }
  strcpy(info->user, t);

  if ((t=strtok(NULL, "")) == NULL) {
    free(purl);
    free(info);
    return NULL;
  }
  strcpy(info->service, t);
      
  
  purl->fd = -1;
  purl->transtype = ttype;
  purl->state = CONNECTIONLESS;
  purl->transinfo = (void *) info;
  purl->hashed = 0;

  strcpy(purl->url, urlstring);
  strcpy(purl->name, info->service);

  purl->alternate = NULL;

  return(purl);
}


/*
 *----------------------------------------------------------------------
 *
 * smailListen --
 *
 *	Listen on smail url host & port
 *
 * Results:
 *	1 if successful
 *      0 for failure
 *
 * Side effects:
 *      Possible establishment of connection
 *
 *----------------------------------------------------------------------
 */

int
#if defined(__STDC__) || defined(__cplusplus)
smailListen(ParsedURL *purl)
#else
smailListen(purl)
     ParsedURL *purl;
#endif
{
  /* use of ServiceMail depends on existence of a TCP entry in the ANS used
     by the Mail Server */

  return(1);
}


/*
 *----------------------------------------------------------------------
 *
 * smailConnect --
 *
 *	Dummy function.
 *
 * Results:
 *      NULL for failure
 *
 * Side effects:
 *
 *----------------------------------------------------------------------
 */

ParsedURL *
#if defined(__STDC__) || defined(__cplusplus)
smailConnect(ParsedURL *purl, int ttype)
#else
smailConnect(purl, ttype)
     ParsedURL *purl;
     int ttype;
#endif
{
  /* NOOP */
  return(NULL);
}


/*
 *----------------------------------------------------------------------
 *
 * smailDisconnect --
 *
 *      Dummy function.
 *
 * Results:
 *	returns 1
 *
 * Side effects:
 *
 *----------------------------------------------------------------------
 */

int
#if defined(__STDC__) || defined(__cplusplus)
smailDisconnect(ParsedURL *purl)
#else
smailDisconnect(purl)
     ParsedURL *purl;
#endif
{
  /* NOOP */
  return(1);
}


/*
 *----------------------------------------------------------------------
 *
 * smailGet --
 *
 *      Dummy function.
 *
 * Results:
 *      NULL for failure.
 *
 * Side effects:
 *
 *----------------------------------------------------------------------
 */

char *
#if defined(__STDC__) || defined(__cplusplus)
smailGet(ParsedURL *purl, char *str)
#else
smailGet(purl, str)
     ParsedURL *purl;
     char *str;
#endif
{
  /* Should never get here */
  return(NULL);
}

/*
 *----------------------------------------------------------------------
 *
 * smailSend --
 *
 *      Send message on smail url
 *
 * Results:
 *	returns 1 if successful
 *      -1 for failure
 *
 * Side effects:
 *
 *----------------------------------------------------------------------
 */

int
#if defined(__STDC__) || defined(__cplusplus)
smailSend(ParsedURL *purl, char *buffer)
#else
smailSend(purl, buffer)
     ParsedURL *purl;
     char *buffer;
#endif
{
  FILE *f;
  SMAILInfo *info = (SMAILInfo *) purl->transinfo;

  DPRINT((stderr, "smailSend sending: %s\n", buffer));

  if ((f = popen(MAILER, "w")) != (FILE*)NULL) {
    fprintf(f, "To: %s@%s\n", info->user, info->host);
    fprintf(f, "Subject: %s\n", info->service);
    fprintf(f, "Content-type: x-kb/x-kqml\n");
    fprintf(f, "Status: R\n\n\n");
    fprintf(f, "%s\n", buffer);
    if (pclose(f) == 0) return 1;
  }

  return -1;
}

#endif

