/*
 * client.c -- example KAPI - JATLite communication program
 *
 * Copyright (c)  1993, 1994 Enterprise Integration Technologies Corporation
 * and Lockheed Missiles and Space Company, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company may not be used in any advertising or publicity
 * relating to the software without the specific, prior written permission
 * of Enterprise Integration Technologies Corporation and Lockheed Missiles
 * and Space Company.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION OR
 * LOCKHEED MISSILES AND SPACE COMPANY BE LIABLE FOR ANY SPECIAL,
 * INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * This example shows how you can communicate with JATLite compatible
 * agent through the JATLite router
 * Author : Heecheol Jeon jhc@cdr.stanford.edu
 * 
 */

#include	<stdio.h>
#include	<string.h>
#include	<kapi.h>

#define         AGENTNAME       "client"
#define         AGENT_URL       "tcp://finch.stanford.edu:2283"
#define ROUTER_URL "tcp://java.stanford.edu:4444"
#define ROUTER_REGISTRAR_URL "tcp://java.stanford.edu:4445"
#define ROUTER_NAME "Router"
#define ROUTER_REGISTRAR_NAME "RouterRegistrar"

int main(argc, argv)
     int	argc;
     char	*argv[];
{
  char	msg_buf[K_MAX_MESSAGE_SIZE];
  int msg_no=0;
    char* sendmsg = "(tell :sender client :receiver ccc :language KQML :content (Hi-Client))";
    /* address string example */
    char* addr_str = "(agent-address :name client :password client :host finch.stanford.edu :port 2283 :message-method MessageRouter)";
    int i;

  /*
   * You can use address structure, instead of address string 
  struct address {
    char *name;
    char *password;
    char *host;
    char *port;
    char *message_method;
    char *email;
    char *kqml_extensions;
  };

  Address*  myaddress = (Address *)calloc( 1,sizeof(Address)); 
  strcpy(myaddress->name,AGENTNAME);
  strcpy(myaddress->password,AGENTNAME);  
  strcpy(myaddress->host,"finch.stanford.edu");
  strcpy(myaddress->port,"2283");
  strcpy(myaddress->message_method,"MessageRouter");
*/   

  KSetUp(AGENTNAME, NULL, 0);

  /* should cache the router */
  KCacheURL(ROUTER_NAME, ROUTER_URL);

  /* optional. If you does not need registration, omit this step.
   * Regsistration to the router is valid until you explicitly
   * say that you will unregister by sending Unregister-agent message
   * using UnregisterRouter function
   */
  KCacheURL(ROUTER_REGISTRAR_NAME,ROUTER_REGISTRAR_URL);

  if (KListen(AGENT_URL) != K_OK) {
    fprintf(stderr,"KListen failure\n");
    exit(0);
  }

  printf("\n ************ %s ************\n", argv[0]);
  printf("\n Make sure a server is running too!\n");
  
  /*  In the case that you want to use Address structure  */
  /*
  KRouterRegister(myaddress,ROUTER_REGISTRAR_NAME);
  KRouterConnect(myaddress,ROUTER_NAME);
  */
  
  /* register to the router */
  KRouterRegisterWithString(addr_str,ROUTER_REGISTRAR_NAME);

  /* connect to the router */
  KRouterConnectWithString(addr_str,ROUTER_NAME);

  /* Loop to send and receive messages */
  for(i=0; i < 3 ; i++) {
    printf("\nEnter message to send: ");

    /* send message */
    if (KSendStringToAMR(sendmsg,ROUTER_NAME) != K_OK) {
      printf("Error: cannot send message to destination.\n");
      exit(0); 
    } 
    
    /* receive message*/
    if (KGetRouterString_or_Wait(msg_buf,ROUTER_NAME) == K_OK) 
      printf("\nMessage received: %s\n\n", msg_buf);
    
    printf("\n =============== %d ===============\n", ++msg_no);

    /* delete mail saved in the file system */
    KSendDeleteMessageToAMR(AGENTNAME,ROUTER_NAME);
  }

  /* disconnect from the router */
  KDisconnectRouter(AGENTNAME,ROUTER_NAME);

  /* disconnect my self */
  KDisconnect();
}


