/*
 * Decompiled with CFR 0.152.
 */
package edu.drexel.gicl.hexclock;

import edu.drexel.gicl.hexclock.ClockListener;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class HexClock
implements Runnable {
    protected boolean stopped = true;
    protected boolean stopRequested = false;
    protected final Vector listeners = new Vector();

    public void addClockListener(ClockListener clockListener) {
        this.listeners.add(clockListener);
    }

    public boolean checkStop() {
        HexClock hexClock = this;
        synchronized (hexClock) {
            if (this.stopRequested) {
                this.stopped = true;
                this.stopRequested = false;
                this.notifyAll();
                boolean bl = true;
                Object var3_4 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_5 = null;
            return bl;
        }
    }

    protected void notifyListeners(Date date, String string) {
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            ClockListener clockListener = (ClockListener)iterator.next();
            clockListener.clockTick(date, string);
        }
    }

    public void removeClockListener(ClockListener clockListener) {
        this.listeners.remove(clockListener);
    }

    public String renderDate() {
        Calendar calendar = Calendar.getInstance();
        return this.renderDate(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public String renderDate(int n, int n2, int n3) {
        String string = Integer.toHexString(n).toUpperCase();
        String string2 = Integer.toHexString(n2).toUpperCase();
        String string3 = Integer.toHexString(n3).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            stringBuffer.append("00");
        } else if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append(":");
        if (string2.length() == 0) {
            stringBuffer.append("00");
        } else if (string2.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string2);
        stringBuffer.append(":");
        if (string3.length() == 0) {
            stringBuffer.append("00");
        } else if (string3.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public void run() {
        HexClock hexClock = this;
        synchronized (hexClock) {
            if (!this.stopped) {
                throw new Error("HexClock started in bad state - already running");
            }
            this.stopped = false;
        }
        long l = -1L;
        while (!this.checkStop()) {
            long l2;
            if (l < 0L || System.currentTimeMillis() - l >= 1000L) {
                l = System.currentTimeMillis();
                Date date = new Date();
                String string = this.renderDate();
                this.notifyListeners(date, string);
            }
            if ((l2 = l + 1000L - System.currentTimeMillis()) < 0L) {
                System.err.println("sleep_time negative");
                System.err.flush();
                l = System.currentTimeMillis();
                l2 = 1000L;
            } else if (l2 > 1000L) {
                System.err.println("sleep_time > 1000");
                System.err.flush();
                l = System.currentTimeMillis();
                l2 = 1000L;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static Thread start() {
        return HexClock.start(new HexClock());
    }

    public static Thread start(HexClock hexClock) {
        Thread thread = new Thread(hexClock);
        thread.start();
        return thread;
    }

    public void stopClock() {
        HexClock hexClock = this;
        synchronized (hexClock) {
            if (this.stopped) {
                Object var2_2 = null;
                return;
            }
            this.stopRequested = true;
            while (!this.stopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

