/*
 * Decompiled with CFR 0.152.
 */
package edu.drexel.gicl.hexclock;

import edu.drexel.gicl.hexclock.ClockListener;
import edu.drexel.gicl.hexclock.HexClock;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import javax.swing.JPanel;

public class HexClockPanel
extends JPanel
implements ClockListener {
    protected String str = "";
    protected final HexClock clock;

    public HexClockPanel(HexClock hexClock) {
        this.clock = hexClock;
        this.clock.addClockListener(this);
        this.setFont(new Font(this.getFont().getFontName(), 1, 20));
    }

    public void clockTick(Date date, String string) {
        this.str = string;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Font font = this.getFont();
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
        int n = 20;
        int n2 = 10;
        int n3 = fontMetrics.stringWidth(this.clock.renderDate()) + 20;
        int n4 = fontMetrics.getHeight() + 10;
        Dimension dimension = new Dimension(n3, n4);
        return dimension;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("hoho");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        HexClock hexClock = new HexClock();
        HexClockPanel hexClockPanel = new HexClockPanel(hexClock);
        frame.add("Center", hexClockPanel);
        HexClock.start(hexClock);
        frame.pack();
        ((Component)frame).setVisible(true);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.black);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.str, graphics2D);
        int n = (this.getWidth() - (int)rectangle2D.getWidth()) / 2;
        int n2 = (this.getHeight() - (int)rectangle2D.getHeight()) / 2 + fontMetrics.getHeight() / 2;
        graphics2D.setPaint(Color.green);
        graphics2D.drawString(this.str, n, n2);
    }

    public void update(Graphics graphics) {
        super.update(graphics);
        this.paint(graphics);
    }
}

