

import java.awt.Dimension;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Box;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;

import javax.swing.BorderFactory;
import javax.swing.border.EtchedBorder;


public class ChordNameDisplayer
    extends JPanel 
    implements ChordNameListener
{
    final JTextField labels[];

    public ChordNameDisplayer(final Scale s) { 
	super();
	labels = new JTextField[ s.getNumTones() ];

	setBorder( BorderFactory.createEtchedBorder(EtchedBorder.RAISED)) ;


	final GridBagLayout gridbag = new GridBagLayout();
	final GridBagConstraints c = new GridBagConstraints();
	c.gridwidth = 1;
	c.gridheight = 1;
	c.fill = GridBagConstraints.BOTH;
	c.gridx = 0;
	c.anchor = GridBagConstraints.WEST;
	c.gridy = GridBagConstraints.RELATIVE;
	setLayout( gridbag );

	Tone t = s.getRoot();
	for ( int i = 0; i < labels.length; ++i ) { 
	    final JLabel tlabel = new JLabel( s.nameTone( t ) + " ", SwingConstants.LEFT );
	    labels[i] = new JTextField( "", 20 );
	    t = s.nextTone( t );

	    c.gridx = 0;
	    c.fill = GridBagConstraints.VERTICAL;
	    gridbag.setConstraints( tlabel, c );
	    add( tlabel );

	    c.gridx = 1;
	    c.fill = GridBagConstraints.BOTH;
	    gridbag.setConstraints( labels[i], c );
	    add( labels[i] );
	}
    }

    public void chordNameEvent ( final String[] names ) { 
	for ( int i = 0; i < names.length; ++i ) { 
	    labels[i].setText( names[i] );
	}
    }
}
