import javax.swing.JApplet;
import javax.swing.JFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.Dimension;
import java.awt.BorderLayout;

public class GuitarNamer 
{

    public static void main ( final String [] args ) { 
	final JFrame f = new JFrame("GuitarNamer");
	f.getAccessibleContext().setAccessibleDescription("Guitar Chord Namer");

	final FretBoard fb = new FretBoard();
	fb.init();
	fb.start();
	
	f.getContentPane().setLayout(new BorderLayout());
	f.getContentPane().add( fb, BorderLayout.CENTER );


	final ChordNameDisplayer cnames = new ChordNameDisplayer( fb.getScale() );
	fb.addChordNameListener( cnames );
	f.getContentPane().add( cnames, BorderLayout.SOUTH );

	f.pack();	
	f.setVisible( true );

	f.addWindowListener( 
			    new WindowAdapter() { 
				    public void windowClosing( final WindowEvent evt ) { 
					System.exit(0);
				    }
				} );
    }
}
