
import java.awt.Dimension;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.Box;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;

public class FretBoard 
    extends JApplet
{

    protected final ChordNamer namer;

    protected final List string_selected_buttons = new ArrayList();
    protected final List string_selected_tones = new ArrayList(); /** List of JLabels */
    protected final List string_selected_tones_tones = new ArrayList(); /** List of Tones */

    protected final FretButtonListener fblistener = 
	new FretButtonListener( this );

    protected class FretButtonListener 
	implements ActionListener { 
	protected final FretBoard fb;
	public FretButtonListener ( FretBoard fb ) { 
	    this.fb = fb;
	}
	
	public void actionPerformed ( final ActionEvent evt ) { 
	    final FretButton fbutton = (FretButton)evt.getSource();
	    final int strix = fbutton.getStringIndex();
	    if ( fb.getActiveButton( strix ) == fbutton ) { 
		fb.deactivateButton( strix );
	    } else {
		fb.deactivateButton( strix );
		fb.activateButton( fbutton, strix );
		System.out.println( "String: " + strix );
		System.out.println( "Note: " + fbutton.getTone().toString() );
	    }
	    
	    notifyChordNameListeners( namer.nameChord( string_selected_tones_tones ) );
	}
    }

    protected final List name_listeners = new ArrayList();
    public void addChordNameListener ( final ChordNameListener n ) { 
	name_listeners.add( n );
    }

    protected void notifyChordNameListeners ( final String[] names ) { 
	for ( final Iterator i = name_listeners.iterator();
	      i.hasNext(); ) { 
	    final ChordNameListener l = (ChordNameListener)i.next();
	    l.chordNameEvent( names );
	}
    }

    /**
     * Return the button fretted on the specified string.
     * Null if none.
     */
    public FretButton getActiveButton( final int strix ) { 
	final FretButton fb = (FretButton)string_selected_buttons.get( strix );
	return fb;
    }

    /**
     * Unfret the specified string.
     */
    public void deactivateButton ( final int strix ) { 
	final FretButton fb = (FretButton)string_selected_buttons.get( strix );
	if ( fb != null ) { 
	    fb.setState( false );
	    final JLabel jl = (JLabel)string_selected_tones.get( strix );
	    jl.setText( " " );
	    string_selected_buttons.set( strix, null );
	    string_selected_tones_tones.set( strix, null );
	}
    }
    /**
     * Fret the specified string at the specified "button".
     */
    public void activateButton ( final FretButton fb, final int strix ) { 
	string_selected_buttons.set( strix, fb );
	if ( fb != null ) 
	    string_selected_tones_tones.set( strix, fb.getTone() );
	fb.setState( true );
	final JLabel jl = (JLabel)string_selected_tones.get( strix );
	jl.setText( chromatic_scale.toString(fb.getTone()) );
    }

    public FretBoard() { 
	super();

	namer = new ChordNamer( getScale() );

	/**
	 * Initialize storage for string fretbutton lists
	 */
	for ( int i = 0, imax = getNStrings(); i < imax; ++i ) { 
	    string_selected_buttons.add( null );
	    string_selected_tones.add( null );
	    string_selected_tones_tones.add( null );
	}
    }

    /**
     * Unfretted tone on each string.
     */
    final Tone[] string_tones = { 
	new Tone(4),
	new Tone(9),
	new Tone(14),
	new Tone(19),
	new Tone(23),
	new Tone(28),
    };
    final ChromaticScale chromatic_scale = new ChromaticScale();

    public Scale getScale() { return chromatic_scale; }

    public void init () { 
	final GridBagLayout gridbag = new GridBagLayout();
	final GridBagConstraints c = new GridBagConstraints();
	c.gridwidth = 1;
	c.gridheight = 1;
	c.fill = GridBagConstraints.BOTH;
	c.gridx = 0;
	c.gridy = 0; /** Throughout, c.gridy acts as an accumulator, everything's relative to it */

	getContentPane().setLayout( gridbag );

	final int nfrets = getNFrets();
	final int nstrings = getNStrings();
	final FretButton[][] fbarray = new FretButton[nstrings][nfrets];

	/**
	 * Pack in a first row of labels, one for each string.
	 */
	for ( int i = 0; i < nstrings; ++i ) { 
	    final JLabel jl = new JLabel( " ", SwingConstants.CENTER);
	    string_selected_tones.set( i, jl );
	    c.gridx = i+1; /** +1 since we'll have a left column of labels too */
	    gridbag.setConstraints( jl, c );
	    getContentPane().add( jl );
	}

	/**
	 * Build a button on each fret for each string...they
	 * get packed in afterwards.
	 */
	for ( int i = 0; i < nstrings; ++i ) { 
	    Tone tone = string_tones[i];
	    for ( int j = 0; j < nfrets; ++j ) { 
		final FretButton fbutton = new FretButton( i, tone );
		fbarray[i][j] = fbutton;
		tone = chromatic_scale.nextTone( tone );
	    }
	}

	for ( int j = 0; j < nfrets; ++j ) { 
	    c.gridx = 0;
	    c.gridy++;

	    if ( c.gridy == 2 ) { 
		final Component b = Box.createVerticalStrut( 10 );
		gridbag.setConstraints( b, c );
		getContentPane().add( b );
		--j;
		continue;
	    }

	    /**
	     * Add a label for the fret number.
	     */
	    final JLabel jl = new JLabel( " " + Integer.toString(j) + " ", 
					  SwingConstants.CENTER);
	    gridbag.setConstraints( jl, c );
	    getContentPane().add( jl );

	    /**
	     * Add each of the fret/string buttons.
	     */
	    for ( int i = 0; i < nstrings; ++i ) { 
		final FretButton fbutton = fbarray[i][j];
		/**
		 * Pack the fretbutton in.
		 */
		c.gridx = i + 1; /** +1 because the labels take up first column */
		gridbag.setConstraints( fbutton, c );
		getContentPane().add( fbutton );

		/**
		 * Add a listener to keep track of buttons.
		 */
		fbutton.addActionListener( new FretButtonListener( this ) );
	    }
	}
    }
    
    protected final String[] stringNames = { "E", "A", "D", "G", "B", "e" };
    protected final int nStrings = 6;
    public int getNStrings() { return nStrings; }
    protected final int nFrets = 15;
    public int getNFrets () { return nFrets; }
}
