
import java.util.WeakHashMap;
import java.util.Map;

public class ChromaticScale
    implements Scale
{ 
    protected final Map cache = new WeakHashMap();
    protected final Tone root;
    protected final String[] tone_names = 
    { "C", "C#",
      "D", "D#",
      "E", 
      "F", "F#",
      "G", "G#",
      "A", "A#",
      "B" };
    protected final int tone_count = tone_names.length;
    public int getNumTones() { return tone_count; }

    public ChromaticScale () { 
	this( new Tone(0) );
    }
    public ChromaticScale ( final Tone root ) { 
	this.root = root;
    }

    public int getNormalInterval ( final Tone t1, final Tone t2 ) { 
	int x = (t2.id - t1.id) % tone_count;	
	while ( x < 0 ) 
	    x += getNumTones();
	return x;
    }
    public int getInterval ( final Tone t1, final Tone t2 ) { 
	return t2.id-t1.id;
    }


    public String nameTone ( final Tone t ) { 
	return this.tone_names[(t.id % tone_count)];
    }

    public Tone nextTone ( final Tone t ) { 
	Tone out = new Tone(t.id+1);
	if ( cache.containsKey(out) ) { 
	    out = (Tone)cache.get( out );
	}
	return out;
    }
    public Tone prevTone ( final Tone t ) { 
	Tone out = new Tone(t.id-1);
	if ( cache.containsKey(out) ) { 
	    out = (Tone)cache.get( out );
	}
	return out;
    }
    public Tone getRoot() { 
	return this.root;
    }
    public String toString ( Tone t ) { 
	return nameTone( t );
    }
}
