

import java.util.List;
import java.util.Iterator;

public class ChordNamer { 



    public ChordNamer ( Scale scale ) { 
	this.scale = scale;
    }

    protected final Scale scale;
    public Scale getScale() { return scale; }
	
    public String[] nameChord ( final List tones ) { 
	final Scale s = getScale();
	final int n = s.getNumTones();
	Tone t = s.getRoot();

	final String[] out = new String[n];

	for ( int i = 0; i < n; ++i ) { 
	    out[i] = tryNameChord( s, t, tones );
	    t = s.nextTone( t );
	}
	return out;
    }

    protected String tryNameChord ( final Scale s,
				    final Tone root,
				    final List tones ) { 
	if ( s.getNumTones() != 12 ) 
	    throw new Error("Too many tones in scale - expecting std. 12 tone chromatic");

	final boolean b[] = new boolean[ s.getNumTones() ];
	for ( int i = 0; i < b.length; ++i ) {
	    b[i] = false; 
	}

	for ( final Iterator i = tones.iterator(); i.hasNext(); ) { 
	    final Tone t = (Tone)i.next();
	    if ( t != null ) { 
		final int ival = s.getNormalInterval( root, t );
		if ( ival < 0 ) System.err.println("BAH - neg interval");
		b[ival] = true;
	    }
	}

	final boolean has_root = b[0];
	
	final boolean minor_color = b[3];
	final boolean major_color = b[4];
	final boolean no_3rd = !(minor_color || major_color);
	
	final boolean has_5th = b[7];
	final boolean has_flat5th = b[6];
	final boolean has_aug5th = b[8];

	final boolean diminished = major_color && has_flat5th;
	final boolean augmented = minor_color && has_aug5th;

	final boolean add2 = b[2];
	final boolean add4 = b[5];
	
	final boolean sus2 = !major_color && add2;
	final boolean sus4 = !major_color && add4;
	
	final boolean has_min7th = b[10];
	final boolean has_maj7th = b[11];
	final boolean has_6th = b[9];

	final boolean seventh = major_color && has_min7th;
	final boolean maj_seventh = major_color && has_maj7th;
	final boolean min_seventh = minor_color && has_min7th;

	final String tonename = s.nameTone( root );

	final int T_1ST = 0;
	final int XXX___IX_UNNAMED_1 = 1;
	final int T_2ND = 2;
	final int T_MINOR_3RD = 3;
	final int T_MAJOR_3RD = 4;
	final int T_4TH = 5;
	final int T_FLAT_5TH = 6;
	final int T_5TH = 7;
	final int T_AUG_5TH = 8;
	final int T_6TH = 9;
	final int T_MIN_7TH = 10;
	final int T_MAJ_7TH = 11;

	final boolean b_1ST = b[T_1ST];
	final boolean b_2ND = b[T_2ND];
	final boolean b_MINOR_3RD = b[T_MINOR_3RD];
	final boolean b_MAJOR_3RD = b[T_MAJOR_3RD];
	final boolean b_4TH = b[T_4TH];
	final boolean b_FLAT_5TH = b[T_FLAT_5TH];
	final boolean b_5TH = b[T_5TH];
	final boolean b_AUG_5TH = b[T_AUG_5TH];
	final boolean b_6TH = b[T_6TH];
	final boolean b_MIN_7TH = b[T_MIN_7TH];
	final boolean b_MAJ_7TH = b[T_MAJ_7TH];
	/**
	 * s_BLAH is true if we're expecting that tone.
	 */
	boolean x_1ST = false;
	boolean x_2ND = false;
	boolean x_MINOR_3RD = false;
	boolean x_MAJOR_3RD = false;
	boolean x_4TH = false;
	boolean x_FLAT_5TH = false;
	boolean x_5TH = false;
	boolean x_AUG_5TH = false;
	boolean x_6TH = false;
	boolean x_MIN_7TH = false;
	boolean x_MAJ_7TH = false;

	boolean s_1ST = false;
	boolean s_2ND = false;
	boolean s_MINOR_3RD = false;
	boolean s_MAJOR_3RD = false;
	boolean s_4TH = false;
	boolean s_FLAT_5TH = false;
	boolean s_5TH = false;
	boolean s_AUG_5TH = false;
	boolean s_6TH = false;
	boolean s_MIN_7TH = false;
	boolean s_MAJ_7TH = false;


	String name = "";

	if ( b_MINOR_3RD && b_MAJOR_3RD ) { 
	    // Things are muddy
	    name = null;
	} else if ( b_MINOR_3RD || b_MAJOR_3RD ) { 
	    if ( b_MINOR_3RD ) {
		x_MINOR_3RD = s_MINOR_3RD = true;
		if ( b_FLAT_5TH ) { 
		    x_FLAT_5TH = s_FLAT_5TH = true;
		    if ( b_MAJ_7TH ) { 
			name += "dim7"; 
			x_MAJ_7TH = s_MAJ_7TH = true; 
		    }
		    else { 
			name += "dim";
		    }
		} else {
		    x_5TH = true;
		    if ( b_MIN_7TH ) { 
			name += "m7";
			x_MIN_7TH = s_MIN_7TH = true;
		    } else if ( b_6TH ) { 
			name += "6min";
			x_6TH = s_6TH = true;
		    } else { 
			name += "min";
		    }
		}
	    } else if ( b_MAJOR_3RD ) { 
		x_MAJOR_3RD = s_MAJOR_3RD = true;
		if ( b_AUG_5TH ) {
		    name += "aug";
		    x_AUG_5TH = s_AUG_5TH = true;
		} else if ( b_MIN_7TH ) { 
		    name += "7";
		    x_MIN_7TH = s_MIN_7TH = true;
		} else if ( b_MAJ_7TH ) { 
		    name += "M7";
		    x_MAJ_7TH = s_MAJ_7TH = true;
		} else if ( b_6TH ) { 
		    name += "6";
		    x_6TH = s_6TH = true;
		} else { 
		    name += "maj";
		    x_5TH = true;
		}
	    }
	} else if ( !b_FLAT_5TH && b_5TH && !b_AUG_5TH  ) { 
	    // A no-3rd chord
	    x_5TH = s_5TH = true;
	    if ( b_MAJ_7TH ) { 
		name += "M7";
		x_MAJOR_3RD = true;
		x_MAJ_7TH = s_MAJ_7TH = true;
	    } else { 
		name += "no3";
	    }
	} else if ( b_FLAT_5TH && !b_5TH && !b_AUG_5TH ) { 
	    // A no-3rd chord
	    x_FLAT_5TH = s_FLAT_5TH = true;
	    x_MINOR_3RD = true;
	    name += "dim";
	} else if ( !b_FLAT_5TH && !b_5TH && b_AUG_5TH ) { 
	    x_AUG_5TH = s_AUG_5TH = true;
	    x_MAJOR_3RD = true;
	    name += "aug";
	} else if ( b_1ST ) { 
	    name = "";
	} else {
	    // Things are REALLY muddy - no 3rds or 5ths or root
	    name = null;
	}

	if ( name == null ) { 
	    name = "";
	} else { 
	    if ( !x_2ND && b_2ND ) name += " add2";
	    else if ( x_2ND && !b_2ND ) name += " no2";
	    
	    if ( !x_4TH && b_4TH ) name += " add4";
	    else if ( x_4TH && !b_4TH ) name += " no4";
	    
	    if ( !x_FLAT_5TH && b_FLAT_5TH ) name += " add5-";
	    else if ( x_FLAT_5TH && !b_FLAT_5TH ) name += " no5-";
	    
	    if ( !x_5TH && b_5TH ) name += " add5";
	    else if ( x_5TH && !b_5TH ) name += " no5";
	    
	    if ( !x_AUG_5TH && b_AUG_5TH ) name += " add5+";
	    else if ( x_AUG_5TH && !b_AUG_5TH ) name += " no5+";
	    
	    if ( !x_6TH && b_6TH ) name += " add6";
	    else if ( x_6TH && !b_6TH ) name += " no6";
	    
	    if ( !x_MIN_7TH && b_MIN_7TH ) name += " +min7";
	    else if ( x_MIN_7TH && !b_MIN_7TH ) name += " -min7";

	    if ( !x_MAJ_7TH && b_MAJ_7TH ) name += " +maj7";
	    else if ( x_MAJ_7TH && !b_MAJ_7TH ) name += " -maj7";
	    
	    
	    if ( !b_1ST ) name += " (no root)";

	    name = tonename + name;
	}

	return name;
	
    }


}
