/*
 * InputEvent.java
 *
 * Created on November 28, 2002, 9:31 PM
 */

package com.softwaterworks.gui.event;

/**
 *
 * @author  Brian Lim Youliang
 */
public class InputEvent extends java.util.EventObject {
    
    public static final int IN_ACTION = 1;
    
    public static final int OUT_ACTION = 2;    
    
    private int action;
    
    private Object object;
    
    /** Creates a new instance of InputEvent */
    public InputEvent(Object source, Object object, int action) {
        super(source);
        if (action >= IN_ACTION && action <= OUT_ACTION) // ensure not out of bounds
            this.action = action;
        else
            this.action = IN_ACTION;
        
        this.object = object;
    }
    
    public int getAction() {
        return action;
    }
    
    public Object getObject() {
        return object;
    }
    
}
