// SUBCLASS IF WANT TO ADD CAPABILITY TO TYPE SCIENTIFIC SYMBOLS LIKE PI, E, ETC

/*
 * NumberTextField.java
 *
 * Created on November 23, 2002, 1:08 AM
 */

package com.softwaterworks.gui;

import java.awt.event.*;

/** The <CODE>NumberTextField</CODE> class subclasses <CODE>JTextField</CODE> to allow
 * only the typing of proper numbers. Only digits, one decimal point after the first
 * digit and one minus sign before any digit can be typed. Command keys - back
 * space, delete, left, right, home, end, keypad left, keypad right and enter -
 * work as per normal. All other keys and cases are consumed. To allow other keys
 * from being processed, this class should be subclassed and the
 * <CODE>processKeyEvent</CODE> method overridden.
 * @author Brian Lim Youliang
 */
public class NumberTextField extends javax.swing.JTextField {
    
    /** Creates a new instance of NumberTextField */
    public NumberTextField() {
        super();
    }
    
    /** Creates a new instance of NumberTextField
     * @param columns the number of columns to use to calculate the preferred width
     */
    public NumberTextField(int columns) {
        super(columns);
    }
    
    /** Creates a new instance of NumberTextField
     * @param text the text to be displayed, or <code>null</code>
     */
    public NumberTextField(String text) {
        super(text);
    }
    
    /** Creates a new instance of NumberTextField
     * @param text the text to be displayed, or <CODE>null</CODE>
     * @param columns the number of columns to use to calculate the preferred width
     */ 
    public NumberTextField(String text, int columns) {
        super(text, columns);
    }
    
    /** Creates a new instance of NumberTextField
     * @param doc the text storage to use; if this is <CODE>null</CODE>, a default will be
     * provided by calling the <CODE>createDefaultModel</CODE> method
     * @param text the text to be displayed, or <code>null</code>
     * @param columns the number of columns to use to calculate
     *   the preferred width; if columns is set to zero, the
     *   preferred width will be whatever naturally results from
     *   the component implementation
     */
    public NumberTextField(javax.swing.text.Document doc, String text, 
    int columns) {
        super(doc, text, columns);
    }
    
    /** Overrides <code>processKeyEvent</code> to process events.
     * Here, filtering of keys is carried out such that only digits, one
     * decimal point and the minus sign can be typed and the following keys can work:
     * back space, delete, left, right, home, end, keypad left, keypad right, enter
     * @param e the key event
     */
    protected void processKeyEvent(KeyEvent e) {
        char key = e.getKeyChar();
        int code = e.getKeyCode();
        
        if (Character.isDigit(key)
             || key == KeyEvent.VK_BACK_SPACE
             || key == KeyEvent.VK_DELETE
             || code == KeyEvent.VK_LEFT
             || code == KeyEvent.VK_RIGHT
             || code == KeyEvent.VK_HOME
             || code == KeyEvent.VK_END
             || code == KeyEvent.VK_KP_LEFT
             || code == KeyEvent.VK_KP_RIGHT
             || code == KeyEvent.VK_ENTER)
            super.processKeyEvent(e);
        // if '.' was typed, but did not exist before and was not at the front
        else if (key == '.' && getText().indexOf('.') == -1
                 && getCaretPosition() != 0)
            super.processKeyEvent(e);
        // if '-' was typed, but did not exist before and it was at the front
        else if(key == KeyEvent.VK_MINUS && getCaretPosition() == 0
                && getText().indexOf('-') == -1)
            super.processKeyEvent(e);
        else
            e.consume();
    }
    
}
