/*
 * Labels.java
 *
 * Created on December 1, 2002, 12:36 PM
 */

package com.softwaterworks.gui;

import java.awt.geom.*;
import java.awt.*;

/**
 *
 * @author  Brian Lim Youliang
 */
public abstract class Labels {
    
    /** Default constrained grid */
    public static final Labels CONSTRAINED = new ContrainedLabels();
    /** Default fixed grid */
    public static final Labels FIXED = new FixedLabels();
    
    /** The spacing used between elements of the labels */    
    protected int spacing = 2;
    
    /** Holds value of property buffer; padding around each label. */
    protected int buffer;
    
    /** Creates a new instance of Labels */
    public Labels() {
        this(50, 6);
    }
    
    /** Creates a new instance of Labels */
    public Labels(int spacing, int buffer) {
        this.spacing = spacing;
        this.buffer = buffer;
    }
    
    /* Method to draw labels to graphics context 
     * @param g the graphics context to draw to
     */
    public abstract void drawLabels(Graphics g, int width, int height,
                                                double magX, double magY,
                                                int transX, int transY);
    
    /** Getter for property buffer.
     * @return Value of property buffer.
     */
    public int getBuffer() {
        return this.buffer;
    }
    
    /** Setter for property buffer.
     * @param buffer New value of property buffer.
     */
    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }
    
}
