/*
 * GridDisplay.java
 *
 * Created on November 24, 2002, 9:22 PM
 */

package com.softwaterworks.gui;

/** The <CODE>GridDisplay</CODE> interface defines methods that allow a component to
 * formally employ a <CODE>Grid</CODE> for display.
 * @author Brian Lim Youliang
 */
public interface GridDisplay {
    
    /** Getter for property grid.
     * @return Value of property grid.
     */
    public Grid getGrid();
    
    /** Setter for property grid.
     * @param grid New value of property grid.
     */    
    public void setGrid(Grid grid);
    
    /** This method is called to prepare the painting of grid lines. It is 
     * called in the <CODE>paint</CODE> and <CODE>print</CODE> methods
     * @param g The <CODE>Graphics</CODE> object to receive painting information
     */    
    public void prepareGrid(java.awt.Graphics g);
    
}
