/*
 * Grid.java
 *
 * Created on November 24, 2002, 9:23 PM
 */

package com.softwaterworks.gui;

import com.softwaterworks.math.plot.*;
import java.awt.*;
import java.awt.geom.*;

/** The <code>Grid</code> class represents an immutable grid entity. It needs to
 * be subclassed to implement grid types. The coordinate system is conventional
 * logical, with origin center.
 * @author  Brian Lim Youliang
 */
public abstract class Grid {
    
    /** Default cartesian grid */
    public static final Grid CARTESIAN = new CartesianGrid();
    /** Default polar grid */
    public static final Grid POLAR = new PolarGrid();
    
    /** The spacing used within the secondary grid */    
    protected int secondarySpacing = 2;
    /** The spacing used within the tertiary grid */    
    protected int tertiarySpacing = 1;
    
    /** Primary grid */
    protected GeneralPath axes;
    /** Secondary grid */
    protected GeneralPath courseGrid;
    /** Tertiary grid */
    protected GeneralPath fineGrid;
    
    /** Whether the grid needs to be updated */
    protected boolean update = true;
    
    /** Creates a new instance of Grid 
     */
    public Grid() {
        this(50, 10);
    }
    
    /** Creates a new instance of Grid
     * @param secondarySpacing The spacing used within the secondary grid
     * @param tertiarySpacing The spacing used within the tertiary grid
     */
    public Grid(int secondarySpacing, int tertiarySpacing) {
        this.secondarySpacing = secondarySpacing;
        this.tertiarySpacing = tertiarySpacing;
        
        axes = new GeneralPath();
        courseGrid = new GeneralPath();
        fineGrid = new GeneralPath();
    }
    
    /** Getter for property name.
     * @return Value of property name.
     *
     */
    public abstract String getName();
    
    /** Getter for property primaryGrid, the grid lines with highest emphasis.
     * @return Value of property primaryGrid.
     */
    public GeneralPath getPrimaryGrid(int width, int height,
                                      double magX, double magY,
                                      int transX, int transY) {
        axes.reset();
        
        // horizontal axis        
        axes.moveTo(-width / 2, transY);
        axes.lineTo(width / 2, transY);
        // vertical axis
        axes.moveTo(transX, -height / 2);
        axes.lineTo(transX, height / 2);
        
        return axes;
    }
    
    /** Getter for property secondaryGrid, the grid lines with intermediate
     * emphasis.
     * @return Value of property secondaryGrid.
     */
    public abstract GeneralPath getSecondaryGrid(int width, int height,
                                                 double magX, double magY,
                                                 int transX, int transY);
    
    /** Getter for property tertiaryGrid, the grid lines with lowest emphasis.
     * @return Value of property tertiaryGrid.
     */
    public abstract GeneralPath getTertiaryGrid(int width, int height,
                                                double magX, double magY,
                                                int transX, int transY);
    
}
