/*
 * FixedLabels.java
 *
 * Created on December 23, 2002, 6:18 PM
 */

package com.softwaterworks.gui;

import java.awt.geom.*;
import java.awt.*;

/**
 *
 * @author  Brian Lim Youliang
 */
public class FixedLabels extends Labels {
    
    /** Creates a new instance of FixedLabels */
    public FixedLabels() {
        super();
    }
    
    /** Creates a new instance of FixedLabels */
    public FixedLabels(int spacing, int buffer) {
        super(spacing, buffer);
    }
    
    /* Method to draw labels to graphics context 
     * @param g the graphics context to draw to
     */
    public void drawLabels(Graphics g, int width, int height,
                                       double magX, double magY,
                                       int transX, int transY) {
        int space = spacing;        
        
        FontMetrics fm = g.getFontMetrics();        
        int i, j, d;
        Rectangle2D r = null;
        String label;
        
        /* an algorithm is used to skip labels out of bounds
         * implemented at i initialization with conditional loop
         */
        
        // positive x
        for (i = (transX < -width / 2) ? -width / 2 - (-width / 2 - transX) % space + space
                                       : transX + space,
             j = (d = (-width / 2 - transX) / space + 1) > 0 ? d : 1; 
             i < width / 2 + space; i += space, j++) {
            label = String.valueOf(j / magX);
            r = fm.getStringBounds(label, g);            
            g.drawString(label, (int)(i - r.getWidth()), (int)(r.getHeight() + transY));                
        }
        
        // negative x
        for (i = (transX - space > width / 2) ? width / 2 - (width / 2 - transX) % space
                                              : transX - space,
             j = (d = (width / 2 - transX) / space) < 0 ? d : -1; 
             i > -width / 2; i -= space, j--) {
            label = String.valueOf(j / magX);
            r = fm.getStringBounds(label, g);
            g.drawString(label, (int)(i - r.getWidth()), (int)(r.getHeight() + transY));
        }
        
        // positive y
        for (i = (transY - space > height / 2) ? height / 2 - (height / 2 - transY) % space
                                         : transY - space,
             j = (d = (height / 2 - transY) / space) < 0 ? d : -1; 
             i > -height / 2 - space; i -= space, j--) {
            // note flip of sign
            label = String.valueOf(-j / magX);
            r = fm.getStringBounds(label, g);
            g.drawString(label, (int)(-r.getWidth() - buffer + transX), (int)(i + r.getHeight() / 2));
        }
        
        // negative y
        for (i = (transY < -height / 2) ? -height / 2 - (-height / 2 - transY) % space + space
                                        : transY + space,
             j = (d = (-height / 2 - transY) / space + 1) > 0 ? d : 1; 
             i < height / 2; i += space, j++) {
            // note flip of sign
            label = String.valueOf(-j / magX);
            r = fm.getStringBounds(label, g);
            g.drawString(label, (int)(-r.getWidth() - buffer + transX), (int)(i + r.getHeight() / 2));
        }
        
        // origin
        String originExp = "\u0040";
        r = fm.getStringBounds(originExp, g);
        g.drawString(originExp, (int)(- r.getWidth() + transX - buffer), (int)(r.getHeight() + transY));
    }
    
}
