/*
 * ContrainedLabels.java
 *
 * Created on December 23, 2002, 11:36 AM
 */

package com.softwaterworks.gui;

import java.awt.geom.*;
import java.awt.*;

/**
 *
 * @author  Brian Lim Youliang
 */
public class ContrainedLabels extends Labels {
    
    /** Creates a new instance of ContrainedLabels */
    public ContrainedLabels() {
        super();
    }
    
    /** Creates a new instance of ContrainedLabels */
    public ContrainedLabels(int spacing, int buffer) {        
        super(spacing, buffer);
    }
    
    /* markers to indicate whether the axes have exceeded certain borders */
    private boolean exceedTop;
    private boolean exceedBottom;
    private boolean exceedLeft;
    private boolean exceedRight;
    
    /* Method to draw labels to graphics context 
     * @param g the graphics context to draw to
     */
    public void drawLabels(Graphics g, int width, int height,
                                       double magX, double magY,
                                       int transX, int transY) {        
        int space = spacing;        
        
        FontMetrics fm = g.getFontMetrics();        
        int i, j, d;
        Rectangle2D r = null;
        String label;
        
        // if translated such that the horizontal labels are above the top edge
        if (transY < -height / 2) exceedTop = true;
        // if translated such that the horizontal labels are below the bottom edge
        else if (transY + fm.getHeight() + buffer > height / 2) exceedBottom = true;
        else {
            exceedTop = false;
            exceedBottom = false;
        }
        /* if translated such that the vertical labels are beyond the left edge
         * if (transX < -width / 2) exceedLeft = true;
         * process later since label dimension is needed
         */
        // if translated such that the vertical labels are beyond the right edge
        if (transX > width / 2) exceedRight = true;
        else {
            exceedLeft = false;
            exceedRight = false;
        }
        
        /* an algorithm is used to skip labels out of bounds
         * implemented at i initialization with conditional loop
         */
        
        // positive x
        for (i = (transX < -width / 2) ? -width / 2 - (-width / 2 - transX) % space + space
                                       : transX + space,
             j = (d = (-width / 2 - transX) / space + 1) > 0 ? d : 1; 
             i < width / 2 + space; i += space, j++) {
            label = String.valueOf(j / magX);
            r = fm.getStringBounds(label, g);
            
            if (exceedTop) 
                g.drawString(label, (int)(i - r.getWidth()), (int)(-height / 2 + r.getHeight()));
            else if (exceedBottom)
                g.drawString(label, (int)(i - r.getWidth()), (int)(height / 2 - buffer));
            else
                g.drawString(label, (int)(i - r.getWidth()), (int)(r.getHeight() + transY));                
        }
        
        // negative x
        for (i = (transX - space > width / 2) ? width / 2 - (width / 2 - transX) % space
                                              : transX - space,
             j = (d = (width / 2 - transX) / space) < 0 ? d : -1; 
             i > -width / 2; i -= space, j--) {
            label = String.valueOf(j / magX);
            r = fm.getStringBounds(label, g);
            
            if (exceedTop) 
                g.drawString(label, (int)(i - r.getWidth()), (int)(-height / 2 + r.getHeight()));
            else if (exceedBottom)
                g.drawString(label, (int)(i - r.getWidth()), (int)(height / 2 - buffer));
            else
                g.drawString(label, (int)(i - r.getWidth()), (int)(r.getHeight() + transY));
        }
        
        // positive y
        for (i = (transY - space > height / 2) ? height / 2 - (height / 2 - transY) % space
                                         : transY - space,
             j = (d = (height / 2 - transY) / space) < 0 ? d : -1; 
             i > -height / 2 - space; i -= space, j--) {
            // note flip of sign
            label = String.valueOf(-j / magX);
            r = fm.getStringBounds(label, g);
            
            if (transX - r.getWidth() - 2 * buffer < -width / 2/*exceedLeft*/) 
                g.drawString(label, (int)(-width / 2 + buffer), (int)(i + r.getHeight() / 2));
            else if (exceedRight)
                g.drawString(label, (int)(width / 2 - r.getWidth() - buffer), (int)(i + r.getHeight() / 2));     
            else
                g.drawString(label, (int)(-r.getWidth() - buffer + transX), (int)(i + r.getHeight() / 2));           
        }
        
        // negative y
        for (i = (transY < -height / 2) ? -height / 2 - (-height / 2 - transY) % space  + space
                                        : transY + space,
             j = (d = (-height / 2 - transY) / space + 1) > 0 ? d : 1; 
             i < height / 2; i += space, j++) {
            // note flip of sign
            label = String.valueOf(-j / magX);
            r = fm.getStringBounds(label, g);
            
            if (transX - r.getWidth() - 2 * buffer < -width / 2/*exceedLeft*/) 
                g.drawString(label, (int)(-width / 2 + buffer), (int)(i + r.getHeight() / 2));
            else if (exceedRight)
                g.drawString(label, (int)(width / 2 - r.getWidth() - buffer), (int)(i + r.getHeight() / 2));     
            else
                g.drawString(label, (int)(-r.getWidth() - buffer + transX), (int)(i + r.getHeight() / 2));
        }        
        
        // origin
        String originExp = "\u0040";
        r = fm.getStringBounds(originExp, g);
        if (exceedTop)
            g.drawString(originExp, (int)(- r.getWidth() + transX - buffer), (int)(-height / 2 + r.getHeight()));
        else if (transY + r.getHeight() + buffer > height / 2) {
            exceedBottom = true;
            g.drawString(originExp, (int)(- r.getWidth() + transX - buffer), (int)(height / 2 - buffer));
        }
        
        if (transX - r.getWidth() - 2 * buffer < -width / 2) {
            exceedLeft = true;
            g.drawString(originExp, (int)(-width / 2 + buffer), (int)(r.getHeight() + transY));
        }
        else if (exceedRight)
            g.drawString(originExp, (int)(width / 2 - r.getWidth() - buffer), (int)(r.getHeight() + transY));
        
        // within bounds
        if (!(exceedTop || exceedBottom || exceedLeft || exceedRight))
            g.drawString(originExp, (int)(- r.getWidth() + transX - buffer), (int)(r.getHeight() + transY));
    }
    
}
