/*
 * ConcreteAction.java
 *
 * Created on December 10, 2002, 8:32 AM
 */

package com.softwaterworks.gui;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * @author  Brian Lim Youliang
 */
public class ConcreteAction extends AbstractAction {
    
    private EventListenerList listenerList = new EventListenerList();
    
    /** Creates a new instance of NewAction */
    public ConcreteAction() {
        super();
    }
    
    /** Creates a new instance of NewAction */
    public ConcreteAction(String name) {
        this(name, null);
    }
    
    /** Creates a new instance of NewAction */
    public ConcreteAction(String name, Icon icon) {
        super(name, icon);
        // make action command equal to the name
        putValue(ACTION_COMMAND_KEY, name);
    }
    
    public void addActionListener(ActionListener l) {
        listenerList.add(ActionListener.class, l);
    }
    
    public void removeActionListener(ActionListener l) {
        listenerList.remove(ActionListener.class, l);
    }
    
    /** Invoked when an action occurs.
     */
    public void actionPerformed(ActionEvent e) {
        // forward to listeners        
        EventListener[] listeners = listenerList.getListeners(ActionListener.class);
        if (listeners != null)
            for (int i = 0; i < listeners.length; i++)
                ((ActionListener)listeners[i]).actionPerformed(e);
    }
    
}
