/*
 * CartesianGrid.java
 *
 * Created on November 30, 2002, 6:08 PM
 */

package com.softwaterworks.gui;

import java.awt.*;
import java.awt.geom.*;

/** The <code>CartesianGrid</code> class subclasses <code>Grid</code> to represent
 * a Cartesian grid.
 * @author  Brian Lim Youliang
 */
public class CartesianGrid extends Grid {
    
    /** Creates a new instance of CartesianGrid
     */
    public CartesianGrid() {
        super();
    }
    
    /** Creates a new instance of CartesianGrid
     * @param secondarySpacing The spacing used within the secondary grid
     * @param tertiarySpacing The spacing used within the tertiary grid
     */
    public CartesianGrid(int secondarySpacing, int tertiarySpacing) {
        super(secondarySpacing, tertiarySpacing);
    }
    
    /** Getter for property name.
     * @return Value of property name.
     */        
    public String getName() {
        return "Cartesian";
    }
    
    /** Getter for property secondaryondaryGrid, the grid lines of intermediate
     * emphasis.
     * @return Value of property secondaryondaryGrid.
     */
    public GeneralPath getSecondaryGrid(int width, int height,
                                        double magX, double magY,
                                        int transX, int transY) {
        courseGrid.reset();
        
        //int space = (int)(secondarySpacing * magY);
        int space = secondarySpacing;
        
        /* an algorithm is used to skip lines out of bounds
         * implemented at i initialization with conditional loop
         */
        
        /* horizontal lines   
         */
        // above horizontal axis
        for(int i = (transY < -height / 2) ? -height / 2 - (-height / 2 - transY) % space 
                                           : transY;
            i < height / 2; i += space) {
            courseGrid.moveTo(-width / 2, i);
            courseGrid.lineTo(width / 2 , i);
        }
        // below horizontal axis
        for(int i = (transY > height / 2) ? height / 2 - (height / 2 - transY) % space - space
                                           : transY - space;
            i > -height / 2 ; i -= space) {
            courseGrid.moveTo(-width / 2 , i);
            courseGrid.lineTo(width / 2 , i);
        }
        /* vertical lines
         */
        // right of vertical axis
        for(int i = (transX < -width / 2) ? -width / 2 - (-width / 2 - transX) % space 
                                          : transX;
            i < width / 2 ; i += space) {
            courseGrid.moveTo(i, -height / 2 );
            courseGrid.lineTo(i, height / 2 );
        }
        // left of vertical axis
        for(int i = (transX > width / 2) ? width / 2 - (width / 2 - transX) % space - space
                                         : transX - space; 
            i > -width / 2 ; i -= space) {
            courseGrid.moveTo(i, -height / 2 );
            courseGrid.lineTo(i, height / 2 );
        }
        return courseGrid;
    }
    
    /** Getter for property tertiaryGrid, the grid lines of lowest emphasis.
     * @return Value of property tertiaryGrid.
     */
    public GeneralPath getTertiaryGrid(int width, int height,
                                       double magX, double magY,
                                       int transX, int transY) {
        // if configurations are the same, then do not recalculate
        // ...
                                           
        fineGrid.reset();
        
        //int space = (int)(tertiarySpacing * magY);
        int space = tertiarySpacing;

        // horizontal lines
        for(int i = transY; i < height / 2 ; i += space) {
            fineGrid.moveTo(-width / 2 , i);
            fineGrid.lineTo(width / 2 , i);
        }
        for(int i = transY - space; i > -height / 2 ; i -= space) {
            fineGrid.moveTo(-width / 2 , i);
            fineGrid.lineTo(width / 2 , i);
        }
        // vertical lines
        for(int i = transX; i < width / 2 ; i += space) {
            fineGrid.moveTo(i, -height / 2 );
            fineGrid.lineTo(i, height / 2 );
        }
        for(int i = transX - space; i > -width / 2 ; i -= space) {
            fineGrid.moveTo(i, -height / 2 );
            fineGrid.lineTo(i, height / 2 );
        }  
        return fineGrid;
    }
    
    public String toString() {
        return "cartesian";
    }
    
}
