// MAKE PARAM A MODEL FOR BSCROLLSET SUCH THAT DON'T NEED ADAPTER ANYMORE
// BASE ON BOUNDEDRANGEMODEL

/*
 * BScrollSet.java
 *
 * Created on November 22, 2002, 10:29 PM
 */

package com.softwaterworks.gui;

import com.softwaterworks.math.*;
import java.awt.event.*;
import javax.swing.*;
import java.beans.*;

/** The <CODE>BScrollSet</CODE> class represents a GUI with three
 * <CODE>NumberTextField</CODE>s and a scroll bar to set value and bounds
 * properties, which values can be reported. Values changed through the GUI can
 * be reported to property change listeners; if they are programmatically changed,
 * then the changes are not reported.
 * @author Brian Lim Youliang
 */
public class BScrollSet extends javax.swing.JPanel
                        implements BoundedRangeDoubleModel {
    
    /** Holds value of property labelName. */
    private String labelName;     
    
    /** Holds value of property model. */
    private BoundedRangeDoubleModel model;    

    /* To help prevent undesired readjustment of of value
     * justChanged is true if value or bounds changed programmatically
     */
    private transient boolean justChanged = false; 
    
    /** Bounds for the scrollBar. */
    public static int SCROLL_MIN = -500, SCROLL_MAX = 500;
    
    /** Creates new form BScrollSet */
    public BScrollSet() {
        this("name", 0 ,0 ,0);
    }
    
    /** Creates new form BScrollSet
     * @param labelName the label text to be displayed
     */
    public BScrollSet(String labelName) {
        this(labelName, 0, 0, 0);
    }
    
    /** Creates new form BScrollSet
     * @param labelName the label text to be displayed
     * @param value the value of <CODE>value</CODE>
     * @param minimum the value of <CODE>minimum</CODE>
     * @param maximum the value of <CODE>maximum</CODE>
     */
    public BScrollSet(String labelName, double value, double minimum, 
                      double maximum) {                                 
        this(labelName, new DefaultBoundedRangeDoubleModel(value, minimum, maximum));
    }
    
    /** Creates new form BScrollSet
     * @param labelName the label text to be displayed
     * @param value the value of <CODE>value</CODE>
     * @param minimum the value of <CODE>minimum</CODE>
     * @param maximum the value of <CODE>maximum</CODE>
     */
    public BScrollSet(String labelName, BoundedRangeDoubleModel model) {
        super();
        this.labelName = labelName;
        
        initComponents(); 
        
        setModel(model);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        nameLabel = new javax.swing.JLabel();
        minimumField = new com.softwaterworks.gui.NumberTextField();
        scrollBar = new javax.swing.JScrollBar();
        maximumField = new com.softwaterworks.gui.NumberTextField();
        valueField = new com.softwaterworks.gui.NumberTextField();

        nameLabel.setText(getLabelName());
        nameLabel.setToolTipText(getLabelName());
        nameLabel.setMaximumSize(new java.awt.Dimension(60, 16));
        nameLabel.setMinimumSize(new java.awt.Dimension(16, 16));
        nameLabel.setPreferredSize(new java.awt.Dimension(30, 16));
        add(nameLabel);

        minimumField.setText("0.0");
        minimumField.setPreferredSize(new java.awt.Dimension(28, 20));
        minimumField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                minimumFieldActionPerformed(evt);
            }
        });

        add(minimumField);

        scrollBar.setMaximum(SCROLL_MAX);
        scrollBar.setMinimum(SCROLL_MIN);
        scrollBar.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar.setVisibleAmount(0);
        scrollBar.setPreferredSize(new java.awt.Dimension(92, 17));
        scrollBar.addAdjustmentListener(new java.awt.event.AdjustmentListener() {
            public void adjustmentValueChanged(java.awt.event.AdjustmentEvent evt) {
                scrollBarAdjustmentValueChanged(evt);
            }
        });

        scrollBar.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                scrollBarMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                scrollBarMouseReleased(evt);
            }
        });

        add(scrollBar);

        maximumField.setText("0.0");
        maximumField.setPreferredSize(new java.awt.Dimension(28, 20));
        maximumField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                maximumFieldActionPerformed(evt);
            }
        });

        add(maximumField);

        valueField.setText("0.0");
        valueField.setPreferredSize(new java.awt.Dimension(32, 20));
        valueField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                valueFieldActionPerformed(evt);
            }
        });

        add(valueField);

    }//GEN-END:initComponents

    private double oldValue;
    private void scrollBarMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_scrollBarMousePressed
        // Add your handling code here:
        oldValue = model.getValue();
    }//GEN-LAST:event_scrollBarMousePressed

    private void scrollBarMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_scrollBarMouseReleased
        // Add your handling code here:
        double value = model.getValue();
        if (value != oldValue) {
            firePropertyChange("value", oldValue, (float)value);
        }
    }//GEN-LAST:event_scrollBarMouseReleased

    private void scrollBarAdjustmentValueChanged(java.awt.event.AdjustmentEvent evt) {//GEN-FIRST:event_scrollBarAdjustmentValueChanged
        // Add your handling code here:
        if (!justChanged)
            setValue((float)((evt.getValue() - SCROLL_MIN)
                             * (model.getMaximum() - model.getMinimum()) 
                             / (SCROLL_MAX - SCROLL_MIN)
                             + model.getMinimum()));
        
        justChanged = false;
    }//GEN-LAST:event_scrollBarAdjustmentValueChanged

    private void valueFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_valueFieldActionPerformed
        // Add your handling code here:
        double value = Float.parseFloat(evt.getActionCommand());
        
        firePropertyChange("value", model.getValue(), value);
        
        setValue(value);
    }//GEN-LAST:event_valueFieldActionPerformed

    private void maximumFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_maximumFieldActionPerformed
        // Add your handling code here:
        double maximum = Float.parseFloat(evt.getActionCommand());
        
        firePropertyChange("maximum", model.getMaximum(), maximum);
        
        setMaximum(maximum);
    }//GEN-LAST:event_maximumFieldActionPerformed

    private void minimumFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_minimumFieldActionPerformed
        // Add your handling code here:
        double minimum = Float.parseFloat(evt.getActionCommand());
        
        firePropertyChange("minimum", model.getMinimum(), minimum);
        
        // update model
        setMinimum(minimum);
    }//GEN-LAST:event_minimumFieldActionPerformed
    
    /** Getter for property value.
     * @return Value of property value.
     *
     */
    public double getValue() {
        return model.getValue();
    }
    
    /** Setter for property value.
     * @param value New value of property value.
     */
    /*public void setValue(double value) {
        firePropertyChange("value", oldValue, value);
        setValueNoFire(value);
    }*/
    
    /** Setter for property value. Property change not fired
     * @param value New value of property value.
     */
    public void setValue(double value) {
        // update model
        model.setValue(value);
        
        // set scrollBar slider position
        scrollBar.setValue((int)((SCROLL_MAX - SCROLL_MIN) 
                                 * (getValue() - getMinimum()) 
                                 / (getMaximum() - getMinimum()) 
                                 + SCROLL_MIN));
        
        // update display of fields
        valueField.setText(String.valueOf(getValue())); 
        minimumField.setText(String.valueOf(getMinimum())); 
        maximumField.setText(String.valueOf(getMaximum()));    
        
        justChanged = true;
    }
    
    /** Getter for property minimum.
     * @return Value of property minimum.
     */
    public double getMinimum() {
        return model.getMinimum();
    }
    
    /** Setter for property minimum.
     * @param minimum New value of property minimum.
     */
    public void setMinimum(double minimum) {
        //firePropertyChange("minimum", model.getMinimum(), minimum);
        
        model.setMinimum(minimum);
        
        // set scrollBar slider position
        scrollBar.setValue((int)((SCROLL_MAX - SCROLL_MIN) 
                                 * (getValue() - getMinimum()) 
                                 / (getMaximum() - getMinimum()) 
                                 + SCROLL_MIN));
        
        // update display of fields
        valueField.setText(String.valueOf(getValue())); 
        minimumField.setText(String.valueOf(getMinimum())); 
        maximumField.setText(String.valueOf(getMaximum()));  
        
        justChanged = true;
    }
    
    /** Getter for property maximum.
     * @return Value of property maximum.
     */
    public double getMaximum() {
        return model.getMaximum();
    }
    
    /** Setter for property maximum.
     * @param maximum New value of property maximum.
     */
    public void setMaximum(double maximum) {
        //firePropertyChange("maximum", model.getMaximum(), maximum);
        
        // update model
        model.setMaximum(maximum);
        
        // set scrollBar slider position
        scrollBar.setValue((int)((SCROLL_MAX - SCROLL_MIN) 
                                 * (getValue() - getMinimum()) 
                                 / (getMaximum() - getMinimum()) 
                                 + SCROLL_MIN));   
        
        // update display of fields
        valueField.setText(String.valueOf(getValue())); 
        minimumField.setText(String.valueOf(getMinimum())); 
        maximumField.setText(String.valueOf(getMaximum()));  
        
        justChanged = true;
    }
    
    /** Getter for property labelName.
     * @return Value of property labelName.
     */
    public String getLabelName() {
        return this.labelName;
    }
    
    /** Setter for property labelName.
     * @param labelName New value of property labelName.
     */
    public void setLabelName(String labelName) {
        nameLabel.setText(labelName);
    }
    
    /** Getter for property model.
     * @return Value of property model.
     */
    public BoundedRangeDoubleModel getModel() {
        return this.model;
    }
    
    /** Setter for property model.
     * @param model New value of property model.
     */
    public void setModel(BoundedRangeDoubleModel model) {
        this.model = model;        
        
        // set scrollBar slider position
        scrollBar.setValue((int)((SCROLL_MAX - SCROLL_MIN) 
                                 * (getValue() - getMinimum()) 
                                 / (getMaximum() - getMinimum()) 
                                 + SCROLL_MIN));  
        
        // update display of fields
        valueField.setText(String.valueOf(getValue())); 
        minimumField.setText(String.valueOf(getMinimum())); 
        maximumField.setText(String.valueOf(getMaximum()));    
    }
    
    
    
    /**********************************************************************/
    /* Overridden methods                                                 */    
    /**********************************************************************/
    
    /* Sets whether or not this component is enabled. Affects text fields and
     * scroll bar, but not label.
     */
    public void setEnabled(boolean enabled) {
        valueField.setEnabled(enabled); 
        minimumField.setEnabled(enabled); 
        maximumField.setEnabled(enabled);   
        scrollBar.setEnabled(enabled); 
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private com.softwaterworks.gui.NumberTextField maximumField;
    private javax.swing.JLabel nameLabel;
    private com.softwaterworks.gui.NumberTextField minimumField;
    private com.softwaterworks.gui.NumberTextField valueField;
    private javax.swing.JScrollBar scrollBar;
    // End of variables declaration//GEN-END:variables

}
