// CHANGE SCHEME FOR CASE WHEN LB > VAL OR UB < VAL?? SUCH THAT IT AUTOMATES?

/*
 * BRangeSet.java
 *
 * Created on November 23, 2002, 2:09 PM
 */

package com.softwaterworks.gui;

import com.softwaterworks.math.*;
import java.beans.*;

/** The <CODE>BRangeSet</CODE> class is a GUI component consisting of a label
 * contained within the greater than and less then symbols, between two text
 * fields. This component allows a ranged entity to have its range altered through
 * a GUI. The text field on the left is the input for the lower bound, while the
 * one on the right is for the upper bound.
 * @author Brian Lim Youliang
 */
public class BRangeSet extends javax.swing.JPanel
                       implements BoundedRangeDoubleModel {
    
    /** Holds value of property labelName. */
    private String labelName;    
    
    /** Holds value of property model. */
    private BoundedRangeDoubleModel model;    
    
    /** Creates new form BRangeSet */
    public BRangeSet() {
        this("name", 0, 0);
    }
    
    /** Creates new form BRangeSet
     * @param labelName the text of the label in the middle
     * @param minimum initial value of the minimum
     * @param maximum initial value of the maximum
     */
    public BRangeSet(String labelName, double minimum, double maximum) {
        this(labelName, new DefaultBoundedRangeDoubleModel(0, minimum, maximum));        
    }
    
    /** Creates new form BRangeSet
     * @param labelName the text of the label in the middle
     * @param minimum initial value of the lower bound
     * @param maximum initial value of the upper bound
     */
    public BRangeSet(String labelName, BoundedRangeDoubleModel model) {
        super();
        this.labelName = labelName;
        
        initComponents();  
        
        setModel(model);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        minimumField = new com.softwaterworks.gui.NumberTextField();
        gtLabel = new javax.swing.JLabel();
        nameLabel = new javax.swing.JLabel();
        ltLabel = new javax.swing.JLabel();
        maximumField = new com.softwaterworks.gui.NumberTextField();

        setPreferredSize(new java.awt.Dimension(220, 30));
        minimumField.setText("0.0");
        minimumField.setPreferredSize(new java.awt.Dimension(36, 20));
        minimumField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                minimumFieldActionPerformed(evt);
            }
        });

        add(minimumField);

        gtLabel.setText("\u2264");
        add(gtLabel);

        nameLabel.setText(getLabelName());
        add(nameLabel);

        ltLabel.setText("<");
        add(ltLabel);

        maximumField.setText("0.0");
        maximumField.setPreferredSize(new java.awt.Dimension(36, 20));
        maximumField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                maximumFieldActionPerformed(evt);
            }
        });

        add(maximumField);

    }//GEN-END:initComponents

    private void maximumFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_maximumFieldActionPerformed
        // Add your handling code here:
        double maximum = Float.parseFloat(evt.getActionCommand());
        
        firePropertyChange("maximum", model.getMaximum(), maximum);
        
        setMaximum(maximum);
    }//GEN-LAST:event_maximumFieldActionPerformed

    private void minimumFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_minimumFieldActionPerformed
        // Add your handling code here:
        double minimum = Float.parseFloat(evt.getActionCommand());
        
        firePropertyChange("minimum", model.getMinimum(), minimum);
        
        // update model
        setMinimum(minimum);
    }//GEN-LAST:event_minimumFieldActionPerformed

    /** Getter for property minimum.
     * @return Value of property minimum.
     *
     */
    public double getMinimum() {
        return model.getMinimum();
    }
    
    /** Setter for property minimum.
     * @param minimum New value of property minimum.
     * @throws PropertyVetoException when minimum > value
     */
    public void setMinimum(double minimum) {       
        //firePropertyChange("minimum", model.getMinimum(), minimum);
        
        // update model
        model.setMinimum(minimum);
        
        // update display of fields
        minimumField.setText(String.valueOf(getMinimum())); 
        maximumField.setText(String.valueOf(getMaximum()));  
    }
    
    /** Getter for property maximum.
     * @return Value of property maximum.
     *
     */
    public double getMaximum() {
        return model.getMaximum();
    }
    
    /** Setter for property maximum.
     * @param maximum New value of property maximum.
     * @throws PropertyVetoException when maximum < value
     */
    public void setMaximum(double maximum) {
        //firePropertyChange("maximum", model.getMaximum(), maximum);
        
        // update model
        model.setMaximum(maximum);
        
        // update display of fields
        minimumField.setText(String.valueOf(getMinimum())); 
        maximumField.setText(String.valueOf(getMaximum())); 
    }
    
    /** Getter for property value.
     * @return Value of property value.
     */
    public double getValue() {
        return model.getValue();
    }
    
    /** Setter for property value.
     * @param value New value of property value.
     */
    public void setValue(double value) {
        model.setValue(value);
    }
    
    /** Getter for property labelName.
     * @return Value of property labelName.
     *
     */
    public String getLabelName() {
        return this.labelName;
    }
    
    /** Setter for property labelName.
     * @param labelName New value of property labelName.
     *
     */
    public void setLabelName(String labelName) {
        this.labelName = labelName;
        nameLabel.setText(labelName);
    }
    
    /** Getter for property model.
     * @return Value of property model.
     */
    public BoundedRangeDoubleModel getModel() {
        return this.model;
    }
    
    /** Setter for property model.
     * @param model New value of property model.
     */
    public void setModel(BoundedRangeDoubleModel model) {
        this.model = model;    
        
        // update display of fields
        minimumField.setText(String.valueOf(getMinimum())); 
        maximumField.setText(String.valueOf(getMaximum()));   
    }
    
    
    
    /**********************************************************************/
    /* Overridden methods                                                 */    
    /**********************************************************************/
    
    /* Sets whether or not this component is enabled. Affects all components.
     */
    public void setEnabled(boolean enabled) {
        nameLabel.setEnabled(enabled); 
        maximumField.setEnabled(enabled); 
        minimumField.setEnabled(enabled); 
        ltLabel.setEnabled(enabled); 
        gtLabel.setEnabled(enabled); 
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private com.softwaterworks.gui.NumberTextField maximumField;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JLabel ltLabel;
    private com.softwaterworks.gui.NumberTextField minimumField;
    private javax.swing.JLabel gtLabel;
    // End of variables declaration//GEN-END:variables
    
}
